/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.snowflake;

import java.sql.Connection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.snowflake.SnowflakeDatabase;
import org.flywaydb.database.snowflake.SnowflakeParser;

public class SnowflakeDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "Snowflake";
    }

    public int getNullType() {
        return 12;
    }

    public boolean supportsReadOnlyTransactions() {
        return false;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:snowflake:") || url.startsWith("jdbc:p6spy:snowflake:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:snowflake:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "net.snowflake.client.jdbc.SnowflakeDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Snowflake");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SnowflakeDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SnowflakeParser(configuration, parsingContext);
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("user=") && !url.contains("authenticator=externalbrowser");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("private_key_file=") && !url.contains("authenticator=externalbrowser");
    }
}

