/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.oracle;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.regex.Pattern;
import oracle.jdbc.OracleConnection;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.database.oracle.OracleConfigurationExtension;
import org.flywaydb.database.oracle.OracleDatabase;
import org.flywaydb.database.oracle.OracleParser;
import org.flywaydb.database.oracle.OracleSqlScriptExecutor;

public class OracleDatabaseType
extends BaseDatabaseType {
    private static final Log LOG = LogFactory.getLog(OracleDatabaseType.class);
    private static final Pattern usernamePasswordPattern = Pattern.compile("^jdbc:oracle:thin:[a-zA-Z0-9#_$]+/([a-zA-Z0-9#_$]+)@.*");
    private static final String TNS_ADMIN = "TNS_ADMIN";
    private static final String ORACLE_HOME = "ORACLE_HOME";

    public String getName() {
        return "Oracle";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return UrlUtils.isSecretManagerUrl((String)url, (String)"oracle") || url.startsWith("jdbc:oracle") || url.startsWith("jdbc:p6spy:oracle");
    }

    public Pattern getJDBCCredentialsPattern() {
        return usernamePasswordPattern;
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:oracle:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "oracle.jdbc.OracleDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Oracle");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new OracleDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new OracleParser(configuration, parsingContext);
    }

    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
        final boolean supportsBatch = jdbcConnectionFactory.isSupportsBatch();
        OracleDatabaseType thisRef = this;
        return new SqlScriptExecutorFactory(){
            final /* synthetic */ DatabaseType val$thisRef;
            final /* synthetic */ CallbackExecutor val$callbackExecutor;
            final /* synthetic */ StatementInterceptor val$statementInterceptor;
            {
                this.val$thisRef = databaseType;
                this.val$callbackExecutor = callbackExecutor;
                this.val$statementInterceptor = statementInterceptor;
            }

            public SqlScriptExecutor createSqlScriptExecutor(Connection connection, boolean undo, boolean batch, boolean outputQueryResults) {
                if (!supportsBatch) {
                    batch = false;
                }
                return new OracleSqlScriptExecutor(new JdbcTemplate(connection, this.val$thisRef), this.val$callbackExecutor, undo, batch, outputQueryResults, this.val$statementInterceptor);
            }
        };
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        String osUser = System.getProperty("user.name");
        props.put("v$session.osuser", osUser.substring(0, Math.min(osUser.length(), 30)));
        props.put("v$session.program", "Flyway by Redgate");
        props.put("oracle.net.keepAlive", "true");
        String oobb = ClassUtils.getStaticFieldValue((String)"oracle.jdbc.OracleConnection", (String)"CONNECTION_PROPERTY_THIN_NET_DISABLE_OUT_OF_BAND_BREAK", (ClassLoader)classLoader);
        props.put(oobb, "true");
    }

    public void setConfigConnectionProps(Configuration config, Properties props, ClassLoader classLoader) {
        if (config != null) {
            OracleConfigurationExtension configurationExtension = (OracleConfigurationExtension)config.getPluginRegister().getPlugin(OracleConfigurationExtension.class);
            if (configurationExtension.getWalletLocation() != null) {
                throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier((Configuration)config), "oracle.net.wallet_location");
            }
            if (!config.getKerberosConfigFile().isEmpty()) {
                throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier((Configuration)config), "oracle.kerberos.config.file");
            }
        }
    }

    public Connection alterConnectionAsNeeded(Connection connection, Configuration configuration) {
        Map jdbcProperties = configuration.getJdbcProperties();
        if (jdbcProperties != null && jdbcProperties.containsKey("PROXY_USER_NAME")) {
            try {
                OracleConnection oracleConnection;
                block9: {
                    try {
                        if (connection instanceof OracleConnection) {
                            oracleConnection = (OracleConnection)connection;
                            break block9;
                        }
                        if (connection.isWrapperFor(OracleConnection.class)) {
                            oracleConnection = connection.unwrap(OracleConnection.class);
                            break block9;
                        }
                        throw new FlywayException("Unable to extract Oracle connection type from '" + connection.getClass().getName() + "'");
                    }
                    catch (SQLException e) {
                        throw new FlywayException("Unable to unwrap connection type '" + connection.getClass().getName() + "'", (Throwable)e);
                    }
                }
                if (!oracleConnection.isProxySession()) {
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)configuration.getJdbcProperties());
                    oracleConnection.openProxySession(1, props);
                }
            }
            catch (FlywayException e) {
                LOG.warn(e.getMessage());
            }
            catch (SQLException e) {
                throw new FlywayException("Unable to open proxy session: " + e.getMessage(), (Throwable)e);
            }
        }
        return super.alterConnectionAsNeeded(connection, configuration);
    }

    private void registerOracleDriver() {
        try {
            Class<?> driver = ((Object)((Object)this)).getClass().getClassLoader().loadClass("oracle.jdbc.OracleDriver");
            DriverManager.registerDriver((Driver)driver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new FlywayException("Unable to register Oracle driver. AWS Secrets Manager may not work", (Throwable)e);
        }
    }

    public void setEarlyConnectionProps() {
        String oracleHome;
        System.setProperty("oracle.jdbc.Trace", "true");
        String loggingPropertiesFile = Paths.get(ClassUtils.getInstallDir(((Object)((Object)this)).getClass()), "assets/logging.properties").toString();
        if (new File(loggingPropertiesFile).exists()) {
            try (FileInputStream fis2 = new FileInputStream(loggingPropertiesFile);){
                LOG.debug("Initializing Java logging with custom properties file");
                LogManager.getLogManager().readConfiguration(fis2);
            }
            catch (Exception fis2) {
                // empty catch block
            }
        }
        if (StringUtils.hasLength((String)(oracleHome = System.getenv(ORACLE_HOME))) && System.getenv(TNS_ADMIN) == null) {
            System.setProperty(TNS_ADMIN, oracleHome + "/network/admin");
        }
    }
}

