/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mongodb;

import java.sql.Connection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.mongodb.MongoDBDatabase;
import org.flywaydb.database.mongodb.MongoDBParser;

public class MongoDBDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "MongoDB";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:mongodb:") || url.startsWith("jdbc:mongodb+srv:") || url.startsWith("mongodb:") || url.startsWith("mongodb+srv:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        return "com.dbschema.MongoJdbcDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Mongo DB");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new MongoDBDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new MongoDBParser(configuration, parsingContext);
    }
}

