/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mongodb;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.logging.PreviewFeatureWarning;
import org.flywaydb.database.mongodb.MongoDBDatabase;
import org.flywaydb.database.mongodb.MongoDBJdbcTemplate;
import org.flywaydb.database.mongodb.MongoDBSchema;

public class MongoDBConnection
extends org.flywaydb.core.internal.database.base.Connection<MongoDBDatabase> {
    protected MongoDBConnection(MongoDBDatabase database, Connection connection) {
        super((Database)database, connection);
        this.jdbcTemplate = new MongoDBJdbcTemplate(connection, database.getDatabaseType());
        PreviewFeatureWarning.logPreviewFeature((String)"MongoDB support");
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.getDatabaseName();
    }

    public String getDatabaseName() throws SQLException {
        return this.jdbcTemplate.queryForString("db.getName()", new String[0]);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
    }

    public Schema getSchema(String name) {
        return new MongoDBSchema(this.jdbcTemplate, (MongoDBDatabase)this.database, name);
    }
}

