/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.iris;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.stream.IntStream;
import org.flywaydb.community.database.iris.IRISTable;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public class IRISCallback
implements Callback {
    private static final Log LOG = LogFactory.getLog(IRISCallback.class);

    public boolean supports(Event event, Context context) {
        return true;
    }

    public boolean canHandleInTransaction(Event event, Context context) {
        return false;
    }

    public void handle(Event event, Context context) {
        if (event.equals((Object)Event.AFTER_MIGRATE)) {
            IntStream.range(0, IRISTable.totalLocks.get()).forEach(i -> this.unlock(IRISTable.lockedJdbcTemplate));
            IRISTable.totalLocks.set(0);
        }
        IRISTable.lockedJdbcTemplate = null;
        IRISTable.lockedTable = null;
    }

    public String getCallbackName() {
        return this.getClass().getSimpleName();
    }

    private void unlock(JdbcTemplate jdbcTemplate) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = jdbcTemplate.getConnection().prepareStatement("UNLOCK " + IRISTable.lockedTable + " IN EXCLUSIVE MODE");
            preparedStatement.execute();
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement((Statement)preparedStatement);
    }
}

