/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.hsqldb;

import java.sql.SQLException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.hsqldb.HSQLDBDatabase;
import org.flywaydb.database.hsqldb.HSQLDBSchema;

public class HSQLDBTable
extends Table<HSQLDBDatabase, HSQLDBSchema> {
    private static final Log LOG = LogFactory.getLog(HSQLDBTable.class);

    HSQLDBTable(JdbcTemplate jdbcTemplate, HSQLDBDatabase database, HSQLDBSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((HSQLDBDatabase)this.database).quote(new String[]{((HSQLDBSchema)this.schema).getName(), this.name}) + " CASCADE", new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.exists(null, this.schema, this.name, new String[0]);
    }

    protected void doLock() throws SQLException {
        if (!((HSQLDBDatabase)this.database).getVersion().isAtLeast("2")) {
            LOG.debug("Unable to lock " + this + " as Hsql 1.8 does not support locking. No concurrent migration supported.");
            return;
        }
        this.jdbcTemplate.execute("LOCK TABLE " + this + " WRITE", new Object[0]);
    }
}

