/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.duckdb;

import java.sql.Connection;
import org.flywaydb.community.database.duckdb.DuckDBConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class DuckDBDatabase
extends Database<DuckDBConnection> {
    public DuckDBDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected DuckDBConnection doGetConnection(Connection connection) {
        return new DuckDBConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String createTable = "    CREATE TABLE %s (\n        installed_rank INTEGER NOT NULL,\n        version        VARCHAR,\n        description    VARCHAR NOT NULL,\n        type           VARCHAR NOT NULL,\n        script         VARCHAR NOT NULL,\n        checksum       INTEGER,\n        installed_by   VARCHAR NOT NULL,\n        installed_on   TIMESTAMP NOT NULL DEFAULT now(),\n        execution_time INTEGER NOT NULL,\n        success        BOOLEAN NOT NULL\n    );\n".formatted(table);
        String baselineStatement = baseline ? this.getBaselineStatement(table) + ";\n" : "";
        return createTable + baselineStatement;
    }
}

