/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.derby;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.derby.DerbyConnection;

public class DerbyDatabase
extends Database<DerbyConnection> {
    public DerbyDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected DerbyConnection doGetConnection(Connection connection) {
        return new DerbyConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("10.11.1.1");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("10.14", Tier.PREMIUM, configuration);
        this.recommendFlywayUpgradeIfNecessary("10.15");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + String.valueOf(table) + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\");\nCREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\");";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((DerbyConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT CURRENT_USER FROM SYSIBM.SYSDUMMY1", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }
}

