/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cassandra;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.cassandra.CassandraConnection;

public class CassandraDatabase
extends Database<CassandraConnection> {
    public CassandraDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected CassandraConnection doGetConnection(Connection connection) {
        return new CassandraConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public boolean catalogIsSchema() {
        return true;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + String.valueOf(table) + " (\n    installed_rank INT,\n    version VARCHAR,\n    partition VARCHAR,\n    description VARCHAR,\n    type VARCHAR,\n    script VARCHAR,\n    checksum INT,\n    installed_by VARCHAR,\n    installed_on TIMESTAMP,\n    execution_time INT,\n    success BOOLEAN,\n    PRIMARY KEY ((partition), installed_rank));\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX \"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\");";
    }

    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote(new String[]{"installed_rank"}) + "," + this.quote(new String[]{"version"}) + "," + this.quote(new String[]{"description"}) + "," + this.quote(new String[]{"type"}) + "," + this.quote(new String[]{"script"}) + "," + this.quote(new String[]{"checksum"}) + "," + this.quote(new String[]{"installed_on"}) + "," + this.quote(new String[]{"installed_by"}) + "," + this.quote(new String[]{"execution_time"}) + "," + this.quote(new String[]{"success"}) + " FROM " + String.valueOf(table) + " WHERE " + this.quote(new String[]{"installed_rank"}) + " > ? ALLOW FILTERING";
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + String.valueOf(table) + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"partition"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, 'flyway', ?, ?, ?, ?, ?, toTimestamp(now()), ?, ?)";
    }

    public String getUpdateStatement(Table table) {
        return super.getUpdateStatement(table) + " and partition='flyway'";
    }

    public Set<String> getSystemSchemas() {
        return Set.of("system", "system_auth", "system_schema", "system_distributed", "system_traces", "system_views", "system_virtual_schema");
    }

    public Pair<String, Object> getDeleteStatement(Table table, boolean version, String filter) {
        try {
            String selectStatement = "SELECT " + this.quote(new String[]{"installed_rank"}) + " FROM " + String.valueOf(table) + " WHERE " + this.quote(new String[]{"success"}) + " = " + this.getBooleanFalse() + " AND " + (version ? this.quote(new String[]{"version"}) + " = ?" : this.quote(new String[]{"description"}) + " = ?") + " ALLOW FILTERING";
            String installedRank = this.jdbcTemplate.queryForString(selectStatement, new String[]{filter});
            if (!StringUtils.hasText((String)installedRank)) {
                return null;
            }
            String deleteStatement = "DELETE FROM " + String.valueOf(table) + " WHERE partition='flyway' AND " + this.quote(new String[]{"installed_rank"}) + " = ?";
            return Pair.of((Object)deleteStatement, (Object)Integer.valueOf(installedRank));
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair Schema History table. Query statement failed due to " + e.getMessage(), e);
        }
    }
}

