/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cassandra;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.cassandra.CassandraDatabase;
import org.flywaydb.database.cassandra.CassandraTable;

public class CassandraSchema
extends Schema<CassandraDatabase, CassandraTable> {
    public CassandraSchema(JdbcTemplate jdbcTemplate, CassandraDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("select count(*) from system_schema.keyspaces where keyspace_name=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        return ((CassandraTable[])this.allTables()).length == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE KEYSPACE IF NOT EXISTS " + ((CassandraDatabase)this.database).quote(new String[]{this.name}) + " WITH REPLICATION = { 'class' : 'SimpleStrategy', 'replication_factor' : '1' };", new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP KEYSPACE " + ((CassandraDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doClean() throws SQLException {
        if (this.isSystem()) {
            throw new FlywayException("Clean not supported for system schemas " + ((CassandraDatabase)this.database).quote(new String[]{this.name}) + "!");
        }
        for (String statement : this.dropIndexes()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.dropViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.dropAggregates()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.dropFunctions()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (CassandraTable table : (CassandraTable[])this.allTables()) {
            table.drop();
        }
        for (String statement : this.dropTypes()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> dropIndexes() throws SQLException {
        List indexNames = this.jdbcTemplate.queryForStringList("select index_name from system_schema.indexes where keyspace_name=?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String indexName : indexNames) {
            statements.add("drop index " + ((CassandraDatabase)this.database).quote(new String[]{this.name, indexName}));
        }
        return statements;
    }

    private List<String> dropViews() throws SQLException {
        List viewNames = this.jdbcTemplate.queryForStringList("select view_name from system_schema.views where keyspace_name=?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP MATERIALIZED VIEW " + ((CassandraDatabase)this.database).quote(new String[]{this.name, viewName}));
        }
        return statements;
    }

    private List<String> dropFunctions() throws SQLException {
        List functionNames = this.jdbcTemplate.queryForStringList("select function_name from system_schema.functions where keyspace_name=?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String functionName : functionNames) {
            statements.add("DROP FUNCTION " + ((CassandraDatabase)this.database).quote(new String[]{this.name, functionName}));
        }
        return statements;
    }

    private List<String> dropAggregates() throws SQLException {
        List aggregateNames = this.jdbcTemplate.queryForStringList("select aggregate_name from system_schema.aggregates where keyspace_name=?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String aggregateName : aggregateNames) {
            statements.add("DROP AGGREGATE " + ((CassandraDatabase)this.database).quote(new String[]{this.name, aggregateName}));
        }
        return statements;
    }

    private List<String> dropTypes() throws SQLException {
        List typeNames = this.jdbcTemplate.queryForStringList("select type_name from system_schema.types where keyspace_name = ?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String typeName : typeNames) {
            statements.add("DROP TYPE " + ((CassandraDatabase)this.database).quote(new String[]{this.name, typeName}));
        }
        return statements;
    }

    protected CassandraTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("select table_name from system_schema.tables where keyspace_name=?", new String[]{this.name});
        return (CassandraTable[])tableNames.stream().map(tableName -> new CassandraTable(this.jdbcTemplate, (CassandraDatabase)this.database, this, (String)tableName)).toArray(CassandraTable[]::new);
    }

    public Table getTable(String tableName) {
        return new CassandraTable(this.jdbcTemplate, (CassandraDatabase)this.database, this, tableName);
    }

    private boolean isSystem() {
        return ((CassandraDatabase)this.database).getSystemSchemas().contains(this.name);
    }
}

