/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cassandra;

import java.sql.Connection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.cassandra.CassandraDatabase;
import org.flywaydb.database.cassandra.CassandraParser;

public class CassandraDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "Cassandra";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:cassandra:") || url.startsWith("jdbc:p6spy:cassandra");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:cassandra")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.ing.data.cassandra.jdbc.CassandraDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Cassandra");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new CassandraDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new CassandraParser(configuration, parsingContext);
    }
}

