/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cassandra;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.database.cassandra.CassandraDatabase;
import org.flywaydb.database.cassandra.CassandraSchema;

public class CassandraConnection
extends org.flywaydb.core.internal.database.base.Connection<CassandraDatabase> {
    private static final String DEFAULT_KEYSPACE = "system";

    protected CassandraConnection(CassandraDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.getJdbcConnection().getSchema() == null ? DEFAULT_KEYSPACE : this.getJdbcConnection().getSchema();
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("USE " + ((CassandraDatabase)this.database).quote(new String[]{schema}), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new CassandraSchema(this.jdbcTemplate, (CassandraDatabase)this.database, name);
    }
}

