/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.configuration.models.PropertyResolver;
import org.flywaydb.core.internal.util.MergeUtils;

public class FlywayModel {
    private String environment;
    private Boolean detectEncoding;
    private String encoding;
    private String placeholderPrefix;
    private String placeholderSuffix;
    private String placeholderSeparator;
    private String scriptPlaceholderPrefix;
    private String scriptPlaceholderSuffix;
    private String sqlMigrationPrefix;
    private String undoSqlMigrationPrefix;
    private String repeatableSqlMigrationPrefix;
    private String sqlMigrationSeparator;
    private List<String> sqlMigrationSuffixes;
    private String licenseKey;
    private Boolean oracleSqlplus;
    private Boolean oracleSqlplusWarn;
    private Boolean cleanDisabled;
    private Boolean cleanOnValidationError;
    private List<String> locations;
    private String table;
    private String tablespace;
    private String target;
    private Boolean failOnMissingTarget;
    private List<String> cherryPick;
    private Boolean placeholderReplacement;
    private List<String> ignoreMigrationPatterns;
    private Boolean validateMigrationNaming;
    private Boolean validateOnMigrate;
    private String baselineVersion;
    private String baselineDescription;
    private Boolean baselineOnMigrate;
    private Boolean outOfOrder;
    private Boolean skipExecutingMigrations;
    private List<String> callbacks;
    private Boolean skipDefaultCallbacks;
    private List<String> migrationResolvers;
    private Boolean skipDefaultResolvers;
    private Boolean mixed;
    private Boolean group;
    private String installedBy;
    private Boolean createSchemas;
    private List<String> errorOverrides;
    private String dryRunOutput;
    private Boolean stream;
    private Boolean batch;
    private Boolean outputQueryResults;
    private Integer lockRetryCount;
    private String kerberosConfigFile;
    private String oracleKerberosCacheFile;
    private String oracleWalletLocation;
    private Boolean failOnMissingLocations;
    private List<String> loggers;
    private Map<String, String> placeholders;
    private String defaultSchema;
    private Map<String, PropertyResolver> propertyResolvers;

    public FlywayModel defaults() {
        this.detectEncoding = false;
        this.encoding = "UTF-8";
        this.placeholderPrefix = "${";
        this.placeholderSuffix = "}";
        this.placeholderSeparator = ":";
        this.scriptPlaceholderPrefix = "FP__";
        this.scriptPlaceholderSuffix = "__";
        this.sqlMigrationPrefix = "V";
        this.undoSqlMigrationPrefix = "U";
        this.repeatableSqlMigrationPrefix = "R";
        this.sqlMigrationSeparator = "__";
        this.sqlMigrationSuffixes = Arrays.asList(".sql");
        this.oracleSqlplus = false;
        this.oracleSqlplusWarn = false;
        this.cleanDisabled = true;
        this.cleanOnValidationError = false;
        this.locations = Arrays.asList("db/migration");
        this.target = "latest";
        this.table = "flyway_schema_history";
        this.failOnMissingTarget = false;
        this.cherryPick = new ArrayList<String>();
        this.placeholderReplacement = true;
        this.ignoreMigrationPatterns = Arrays.asList("*:future");
        this.validateMigrationNaming = false;
        this.validateOnMigrate = true;
        this.baselineVersion = "1";
        this.baselineDescription = "<< Flyway Baseline >>";
        this.baselineOnMigrate = false;
        this.outOfOrder = false;
        this.skipExecutingMigrations = false;
        this.callbacks = new ArrayList<String>();
        this.skipDefaultCallbacks = false;
        this.migrationResolvers = new ArrayList<String>();
        this.skipDefaultResolvers = false;
        this.mixed = false;
        this.group = false;
        this.createSchemas = true;
        this.errorOverrides = new ArrayList<String>();
        this.stream = false;
        this.batch = false;
        this.outputQueryResults = true;
        this.lockRetryCount = 50;
        this.kerberosConfigFile = "";
        this.oracleKerberosCacheFile = "";
        this.failOnMissingLocations = false;
        this.loggers = Arrays.asList("auto");
        this.placeholders = new HashMap<String, String>();
        return this;
    }

    public FlywayModel merge(FlywayModel otherPojo) {
        FlywayModel result = new FlywayModel();
        result.encoding = MergeUtils.merge(this.encoding, otherPojo.encoding);
        result.detectEncoding = MergeUtils.merge(this.detectEncoding, otherPojo.detectEncoding);
        result.placeholderPrefix = MergeUtils.merge(this.placeholderPrefix, otherPojo.placeholderPrefix);
        result.placeholderSuffix = MergeUtils.merge(this.placeholderSuffix, otherPojo.placeholderSuffix);
        result.placeholderSeparator = MergeUtils.merge(this.placeholderSeparator, otherPojo.placeholderSeparator);
        result.scriptPlaceholderPrefix = MergeUtils.merge(this.scriptPlaceholderPrefix, otherPojo.scriptPlaceholderPrefix);
        result.scriptPlaceholderSuffix = MergeUtils.merge(this.scriptPlaceholderSuffix, otherPojo.scriptPlaceholderSuffix);
        result.sqlMigrationPrefix = MergeUtils.merge(this.sqlMigrationPrefix, otherPojo.sqlMigrationPrefix);
        result.undoSqlMigrationPrefix = MergeUtils.merge(this.undoSqlMigrationPrefix, otherPojo.undoSqlMigrationPrefix);
        result.repeatableSqlMigrationPrefix = MergeUtils.merge(this.repeatableSqlMigrationPrefix, otherPojo.repeatableSqlMigrationPrefix);
        result.sqlMigrationSeparator = MergeUtils.merge(this.sqlMigrationSeparator, otherPojo.sqlMigrationSeparator);
        result.sqlMigrationSuffixes = MergeUtils.merge(this.sqlMigrationSuffixes, otherPojo.sqlMigrationSuffixes);
        result.licenseKey = MergeUtils.merge(this.licenseKey, otherPojo.licenseKey);
        result.oracleSqlplus = MergeUtils.merge(this.oracleSqlplus, otherPojo.oracleSqlplus);
        result.oracleSqlplusWarn = MergeUtils.merge(this.oracleSqlplusWarn, otherPojo.oracleSqlplusWarn);
        result.cleanDisabled = MergeUtils.merge(this.cleanDisabled, otherPojo.cleanDisabled);
        result.cleanOnValidationError = MergeUtils.merge(this.cleanOnValidationError, otherPojo.cleanOnValidationError);
        result.locations = MergeUtils.merge(this.locations, otherPojo.locations);
        result.table = MergeUtils.merge(this.table, otherPojo.table);
        result.tablespace = MergeUtils.merge(this.tablespace, otherPojo.tablespace);
        result.target = MergeUtils.merge(this.target, otherPojo.target);
        result.failOnMissingTarget = MergeUtils.merge(this.failOnMissingTarget, otherPojo.failOnMissingTarget);
        result.cherryPick = MergeUtils.merge(this.cherryPick, otherPojo.cherryPick);
        result.placeholderReplacement = MergeUtils.merge(this.placeholderReplacement, otherPojo.placeholderReplacement);
        result.ignoreMigrationPatterns = MergeUtils.merge(this.ignoreMigrationPatterns, otherPojo.ignoreMigrationPatterns);
        result.validateMigrationNaming = MergeUtils.merge(this.validateMigrationNaming, otherPojo.validateMigrationNaming);
        result.validateOnMigrate = MergeUtils.merge(this.validateOnMigrate, otherPojo.validateOnMigrate);
        result.baselineVersion = MergeUtils.merge(this.baselineVersion, otherPojo.baselineVersion);
        result.baselineDescription = MergeUtils.merge(this.baselineDescription, otherPojo.baselineDescription);
        result.baselineOnMigrate = MergeUtils.merge(this.baselineOnMigrate, otherPojo.baselineOnMigrate);
        result.outOfOrder = MergeUtils.merge(this.outOfOrder, otherPojo.outOfOrder);
        result.skipExecutingMigrations = MergeUtils.merge(this.skipExecutingMigrations, otherPojo.skipExecutingMigrations);
        result.callbacks = MergeUtils.merge(this.callbacks, otherPojo.callbacks);
        result.skipDefaultCallbacks = MergeUtils.merge(this.skipDefaultCallbacks, otherPojo.skipDefaultCallbacks);
        result.migrationResolvers = MergeUtils.merge(this.migrationResolvers, otherPojo.migrationResolvers);
        result.skipDefaultResolvers = MergeUtils.merge(this.skipDefaultResolvers, otherPojo.skipDefaultResolvers);
        result.mixed = MergeUtils.merge(this.mixed, otherPojo.mixed);
        result.group = MergeUtils.merge(this.group, otherPojo.group);
        result.installedBy = MergeUtils.merge(this.installedBy, otherPojo.installedBy);
        result.createSchemas = MergeUtils.merge(this.createSchemas, otherPojo.createSchemas);
        result.errorOverrides = MergeUtils.merge(this.errorOverrides, otherPojo.errorOverrides);
        result.dryRunOutput = MergeUtils.merge(this.dryRunOutput, otherPojo.dryRunOutput);
        result.stream = MergeUtils.merge(this.stream, otherPojo.stream);
        result.batch = MergeUtils.merge(this.batch, otherPojo.batch);
        result.outputQueryResults = MergeUtils.merge(this.outputQueryResults, otherPojo.outputQueryResults);
        result.lockRetryCount = MergeUtils.merge(this.lockRetryCount, otherPojo.lockRetryCount);
        result.kerberosConfigFile = MergeUtils.merge(this.kerberosConfigFile, otherPojo.kerberosConfigFile);
        result.oracleKerberosCacheFile = MergeUtils.merge(this.oracleKerberosCacheFile, otherPojo.oracleKerberosCacheFile);
        result.oracleWalletLocation = MergeUtils.merge(this.oracleWalletLocation, otherPojo.oracleWalletLocation);
        result.failOnMissingLocations = MergeUtils.merge(this.failOnMissingLocations, otherPojo.failOnMissingLocations);
        result.loggers = MergeUtils.merge(this.loggers, otherPojo.loggers);
        result.defaultSchema = MergeUtils.merge(this.defaultSchema, otherPojo.defaultSchema);
        result.placeholders = MergeUtils.merge(this.placeholders, otherPojo.placeholders);
        result.propertyResolvers = MergeUtils.merge(this.propertyResolvers, otherPojo.propertyResolvers, (a, b) -> b != null ? b : a);
        return result;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Boolean getDetectEncoding() {
        return this.detectEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getPlaceholderSeparator() {
        return this.placeholderSeparator;
    }

    public String getScriptPlaceholderPrefix() {
        return this.scriptPlaceholderPrefix;
    }

    public String getScriptPlaceholderSuffix() {
        return this.scriptPlaceholderSuffix;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public String getUndoSqlMigrationPrefix() {
        return this.undoSqlMigrationPrefix;
    }

    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public Boolean getOracleSqlplus() {
        return this.oracleSqlplus;
    }

    public Boolean getOracleSqlplusWarn() {
        return this.oracleSqlplusWarn;
    }

    public Boolean getCleanDisabled() {
        return this.cleanDisabled;
    }

    public Boolean getCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getTable() {
        return this.table;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public String getTarget() {
        return this.target;
    }

    public Boolean getFailOnMissingTarget() {
        return this.failOnMissingTarget;
    }

    public List<String> getCherryPick() {
        return this.cherryPick;
    }

    public Boolean getPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    public List<String> getIgnoreMigrationPatterns() {
        return this.ignoreMigrationPatterns;
    }

    public Boolean getValidateMigrationNaming() {
        return this.validateMigrationNaming;
    }

    public Boolean getValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public String getBaselineVersion() {
        return this.baselineVersion;
    }

    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public Boolean getBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public Boolean getOutOfOrder() {
        return this.outOfOrder;
    }

    public Boolean getSkipExecutingMigrations() {
        return this.skipExecutingMigrations;
    }

    public List<String> getCallbacks() {
        return this.callbacks;
    }

    public Boolean getSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public List<String> getMigrationResolvers() {
        return this.migrationResolvers;
    }

    public Boolean getSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    public Boolean getMixed() {
        return this.mixed;
    }

    public Boolean getGroup() {
        return this.group;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public Boolean getCreateSchemas() {
        return this.createSchemas;
    }

    public List<String> getErrorOverrides() {
        return this.errorOverrides;
    }

    public String getDryRunOutput() {
        return this.dryRunOutput;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Boolean getBatch() {
        return this.batch;
    }

    public Boolean getOutputQueryResults() {
        return this.outputQueryResults;
    }

    public Integer getLockRetryCount() {
        return this.lockRetryCount;
    }

    public String getKerberosConfigFile() {
        return this.kerberosConfigFile;
    }

    public String getOracleKerberosCacheFile() {
        return this.oracleKerberosCacheFile;
    }

    public String getOracleWalletLocation() {
        return this.oracleWalletLocation;
    }

    public Boolean getFailOnMissingLocations() {
        return this.failOnMissingLocations;
    }

    public List<String> getLoggers() {
        return this.loggers;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public Map<String, PropertyResolver> getPropertyResolvers() {
        return this.propertyResolvers;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setDetectEncoding(Boolean detectEncoding) {
        this.detectEncoding = detectEncoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setPlaceholderSeparator(String placeholderSeparator) {
        this.placeholderSeparator = placeholderSeparator;
    }

    public void setScriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        this.scriptPlaceholderPrefix = scriptPlaceholderPrefix;
    }

    public void setScriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        this.scriptPlaceholderSuffix = scriptPlaceholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setUndoSqlMigrationPrefix(String undoSqlMigrationPrefix) {
        this.undoSqlMigrationPrefix = undoSqlMigrationPrefix;
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public void setSqlMigrationSuffixes(List<String> sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public void setOracleSqlplus(Boolean oracleSqlplus) {
        this.oracleSqlplus = oracleSqlplus;
    }

    public void setOracleSqlplusWarn(Boolean oracleSqlplusWarn) {
        this.oracleSqlplusWarn = oracleSqlplusWarn;
    }

    public void setCleanDisabled(Boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public void setCleanOnValidationError(Boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setFailOnMissingTarget(Boolean failOnMissingTarget) {
        this.failOnMissingTarget = failOnMissingTarget;
    }

    public void setCherryPick(List<String> cherryPick) {
        this.cherryPick = cherryPick;
    }

    public void setPlaceholderReplacement(Boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setIgnoreMigrationPatterns(List<String> ignoreMigrationPatterns) {
        this.ignoreMigrationPatterns = ignoreMigrationPatterns;
    }

    public void setValidateMigrationNaming(Boolean validateMigrationNaming) {
        this.validateMigrationNaming = validateMigrationNaming;
    }

    public void setValidateOnMigrate(Boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setBaselineVersion(String baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(Boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(Boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public void setSkipExecutingMigrations(Boolean skipExecutingMigrations) {
        this.skipExecutingMigrations = skipExecutingMigrations;
    }

    public void setCallbacks(List<String> callbacks) {
        this.callbacks = callbacks;
    }

    public void setSkipDefaultCallbacks(Boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setMigrationResolvers(List<String> migrationResolvers) {
        this.migrationResolvers = migrationResolvers;
    }

    public void setSkipDefaultResolvers(Boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public void setMixed(Boolean mixed) {
        this.mixed = mixed;
    }

    public void setGroup(Boolean group) {
        this.group = group;
    }

    public void setInstalledBy(String installedBy) {
        this.installedBy = installedBy;
    }

    public void setCreateSchemas(Boolean createSchemas) {
        this.createSchemas = createSchemas;
    }

    public void setErrorOverrides(List<String> errorOverrides) {
        this.errorOverrides = errorOverrides;
    }

    public void setDryRunOutput(String dryRunOutput) {
        this.dryRunOutput = dryRunOutput;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setBatch(Boolean batch) {
        this.batch = batch;
    }

    public void setOutputQueryResults(Boolean outputQueryResults) {
        this.outputQueryResults = outputQueryResults;
    }

    public void setLockRetryCount(Integer lockRetryCount) {
        this.lockRetryCount = lockRetryCount;
    }

    public void setKerberosConfigFile(String kerberosConfigFile) {
        this.kerberosConfigFile = kerberosConfigFile;
    }

    public void setOracleKerberosCacheFile(String oracleKerberosCacheFile) {
        this.oracleKerberosCacheFile = oracleKerberosCacheFile;
    }

    public void setOracleWalletLocation(String oracleWalletLocation) {
        this.oracleWalletLocation = oracleWalletLocation;
    }

    public void setFailOnMissingLocations(Boolean failOnMissingLocations) {
        this.failOnMissingLocations = failOnMissingLocations;
    }

    public void setLoggers(List<String> loggers) {
        this.loggers = loggers;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void setPropertyResolvers(Map<String, PropertyResolver> propertyResolvers) {
        this.propertyResolvers = propertyResolvers;
    }
}

