/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;

public class TomlUtils {
    private static final Log LOG = LogFactory.getLog(TomlUtils.class);

    public static Map<String, String> loadConfigurationFile(File configFile, String encoding) {
        if (!configFile.isFile() || !configFile.canRead()) {
            return new HashMap<String, String>();
        }
        LOG.warn("Loading TOML config file: " + configFile.getAbsolutePath());
        LOG.warn("This is an experimental feature, which is subject to change, and not recommended for use as yet");
        TomlMapper tomlMapper = new TomlMapper();
        MapLikeType mapType = tomlMapper.getTypeFactory().constructMapLikeType(Map.class, String.class, Object.class);
        try {
            Map valueMap = (Map)tomlMapper.readValue((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), encoding), (JavaType)mapType);
            return TomlUtils.flatten((Map)valueMap.get("flyway"), "flyway");
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load config file: " + configFile.getAbsolutePath(), e);
        }
    }

    private static Map<String, String> flatten(Map<String, Object> map, String parentKey) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                Map<String, String> subTree = TomlUtils.flatten((Map)value, key);
                for (String subKey : subTree.keySet()) {
                    result.put(parentKey + "." + subKey, subTree.get(subKey));
                }
                continue;
            }
            result.put(parentKey + "." + key, value.toString());
        }
        return result;
    }
}

