/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.resolver;

import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.resolver.ChecksumMatcher;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.info.MigrationInfoContext;

public interface ResolvedMigration
extends ChecksumMatcher {
    public MigrationVersion getVersion();

    public String getDescription();

    public String getScript();

    public Integer getChecksum();

    public MigrationType getType();

    public String getPhysicalLocation();

    public MigrationExecutor getExecutor();

    default public MigrationState getState(MigrationInfoContext context) {
        if (this.getVersion() != null) {
            if (this.getVersion().compareTo(context.lastApplied == MigrationVersion.EMPTY ? context.pendingBaseline : context.appliedBaseline) < 0) {
                return MigrationState.BELOW_BASELINE;
            }
            if (this.getVersion().compareTo(context.lastApplied == MigrationVersion.EMPTY ? context.pendingBaseline : context.appliedBaseline) == 0) {
                return MigrationState.BASELINE_IGNORED;
            }
            if (context.target != null && context.target != MigrationVersion.NEXT && this.getVersion().compareTo(context.target) > 0) {
                return MigrationState.ABOVE_TARGET;
            }
            if (this.getVersion().compareTo(context.lastApplied) < 0 && !context.outOfOrder) {
                return MigrationState.IGNORED;
            }
        }
        return MigrationState.PENDING;
    }

    default public boolean canCompareWith(ResolvedMigration o) {
        return true;
    }
}

