/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.extensibility.TelemetryPlugin;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywayTelemetryManager
implements AutoCloseable {
    private PluginRegister pluginRegister;
    private RootTelemetryModel rootTelemetryModel = new RootTelemetryModel();

    public FlywayTelemetryManager(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
        List<TelemetryPlugin> telemetryPlugins = pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.logRootDetails(this.rootTelemetryModel);
        }
        String userId = System.getenv("RG_TELEMETRY_ANONYMOUS_USER_ID");
        if (!StringUtils.hasText(userId)) {
            boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
            File redgateAppData = isWindows ? new File(System.getenv("APPDATA"), "Redgate") : new File(System.getProperty("user.home"), ".config/Redgate");
            File userIdFile = new File(redgateAppData, "feature_usage_data");
            if (userIdFile.exists()) {
                userId = FileUtils.readAsString(userIdFile.toPath());
            }
            if (!StringUtils.hasText(userId)) {
                userId = UUID.randomUUID().toString();
                if (!redgateAppData.exists()) {
                    redgateAppData.mkdirs();
                }
                try (FileWriter fileWriter = new FileWriter(userIdFile);){
                    fileWriter.write(userId);
                }
                catch (IOException ignore) {
                    System.err.println(ignore.getMessage());
                }
            }
        }
        this.rootTelemetryModel.setUserId(userId);
        String sessionId = System.getenv("RG_TELEMETRY_SESSION_ID");
        if (!StringUtils.hasText(sessionId)) {
            sessionId = UUID.randomUUID().toString();
        }
        this.rootTelemetryModel.setSessionId(sessionId);
        String operationId = System.getenv("RG_TELEMETRY_OPERATION_ID");
        if (!StringUtils.hasText(operationId)) {
            operationId = UUID.randomUUID().toString();
        }
        this.rootTelemetryModel.setOperationId(operationId);
    }

    public void logEvent(EventTelemetryModel model) {
        List<TelemetryPlugin> telemetryPlugins = this.pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.logEventDetails(model);
        }
    }

    @Override
    public void close() throws Exception {
        List<TelemetryPlugin> telemetryPlugins = this.pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.close();
        }
    }

    public RootTelemetryModel getRootTelemetryModel() {
        return this.rootTelemetryModel;
    }

    public void setRootTelemetryModel(RootTelemetryModel rootTelemetryModel) {
        this.rootTelemetryModel = rootTelemetryModel;
    }
}

