/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.FlywayModel;
import org.flywaydb.core.internal.util.MergeUtils;

public class ConfigurationModel {
    private Map<String, EnvironmentModel> environments = new HashMap<String, EnvironmentModel>();
    private FlywayModel flyway = new FlywayModel();
    private String id;

    public static ConfigurationModel defaults() {
        ConfigurationModel model = new ConfigurationModel();
        model.flyway = FlywayModel.defaults();
        model.environments.put("default", new EnvironmentModel());
        return model;
    }

    public ConfigurationModel merge(ConfigurationModel otherPojo) {
        ConfigurationModel result = new ConfigurationModel();
        result.id = MergeUtils.merge(this.id, otherPojo.id);
        result.flyway = this.flyway != null ? this.flyway.merge(otherPojo.flyway) : otherPojo.flyway;
        result.environments = MergeUtils.merge(this.environments, otherPojo.environments, EnvironmentModel::merge);
        return result;
    }

    public static ConfigurationModel clone(ConfigurationModel pojo) {
        ConfigurationModel basePojo = new ConfigurationModel();
        return basePojo.merge(pojo);
    }

    public Map<String, EnvironmentModel> getEnvironments() {
        return this.environments;
    }

    public FlywayModel getFlyway() {
        return this.flyway;
    }

    public String getId() {
        return this.id;
    }

    public void setEnvironments(Map<String, EnvironmentModel> environments) {
        this.environments = environments;
    }

    public void setFlyway(FlywayModel flyway) {
        this.flyway = flyway;
    }

    public void setId(String id) {
        this.id = id;
    }
}

