/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.clean;

import java.util.Arrays;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.command.clean.CleanModel;
import org.flywaydb.core.internal.command.clean.SchemaModel;

public class CleanModeConfigurationExtension
implements ConfigurationExtension {
    private static final String CLEAN_MODE = "flyway.plugins.clean.mode";
    private static final String CLEAN_SCHEMAS_EXCLUDE = "flyway.plugins.clean.schemas.exclude";
    CleanModel clean = new CleanModel();

    @Override
    public String getNamespace() {
        return "plugins";
    }

    @Override
    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_CLEAN_MODE": {
                return CLEAN_MODE;
            }
            case "FLYWAY_PLUGINS_CLEAN_SCHEMAS_EXCLUDE": {
                return CLEAN_SCHEMAS_EXCLUDE;
            }
        }
        return null;
    }

    public void setCleanSchemasExclude(String ... cleanSchemasExclude) {
        this.clean.setSchemas(new SchemaModel());
        this.clean.getSchemas().setExclude(Arrays.asList(cleanSchemasExclude));
    }

    public CleanModel getClean() {
        return this.clean;
    }

    public void setClean(CleanModel clean) {
        this.clean = clean;
    }

    public static enum Mode {
        DEFAULT,
        SCHEMA,
        ALL;


        public static Mode fromString(String string) {
            return Mode.valueOf(string.toUpperCase());
        }
    }
}

