/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.FileWriter;
import org.apache.commons.text.StringEscapeUtils;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.internal.reports.html.HtmlReportGenerator;

public class HtmlUtils {
    public static String toHtmlFile(String filename, CompositeResult<HtmlResult> results, Configuration config) {
        String fileContents = HtmlReportGenerator.generateHtml(results, config);
        try (FileWriter fileWriter = new FileWriter(filename);){
            fileWriter.write(fileContents);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to write HTML to file: " + e.getMessage());
        }
        return filename;
    }

    public static String htmlEncode(String input) {
        return StringEscapeUtils.escapeHtml4((String)input);
    }
}

