/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.internal.util.LocalDateTimeSerializer;

public class JsonUtils {
    public static String jsonToFile(String filename, String json) {
        return JsonUtils.jsonToFile(filename, JsonParser.parseString((String)json).getAsJsonObject());
    }

    public static String jsonToFile(String filename, Object json) {
        String string;
        FileWriter fileWriter = new FileWriter(filename);
        try {
            JsonUtils.getGson().toJson(json, (Appendable)fileWriter);
            string = filename;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlywayException("Unable to write JSON to file: " + e.getMessage());
            }
        }
        fileWriter.close();
        return string;
    }

    public static Gson getGson() {
        return new GsonBuilder().serializeNulls().setPrettyPrinting().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).create();
    }

    public static <T> List<T> toList(String json) {
        Type listType = new TypeToken<ArrayList<T>>(){}.getType();
        return (List)JsonUtils.getGson().fromJson(json, listType);
    }

    public static String getFromJson(String json, String key) {
        return ((JsonObject)JsonUtils.getGson().fromJson(json, JsonObject.class)).get(key).getAsString();
    }

    public static <T extends OperationResult> CompositeResult<T> appendIfExists(String filename, CompositeResult<T> json, JsonDeserializer<CompositeResult<T>> deserializer) {
        CompositeResult existingObject;
        if (!Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            return json;
        }
        Type existingObjectType = new TypeToken<CompositeResult<T>>(){}.getType();
        try (FileReader reader = new FileReader(filename);){
            existingObject = (CompositeResult)new GsonBuilder().registerTypeAdapter(existingObjectType, deserializer).create().fromJson((Reader)reader, existingObjectType);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to read filename: " + filename, e);
        }
        existingObject.individualResults.addAll(json.individualResults);
        return existingObject;
    }

    public static Object parseJsonArray(String json) {
        return JsonParser.parseString((String)json).getAsJsonArray();
    }

    private JsonUtils() {
    }
}

