/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.exception.FlywayValidateException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.UndoResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.command.clean.DbClean;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private final FlywayExecutor flywayExecutor;

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
        this.configuration.loadCallbackLocation("db/callback", false);
        this.flywayExecutor = new FlywayExecutor(this.configuration);
        LogFactory.setConfiguration(this.configuration);
    }

    public Configuration getConfiguration() {
        return new ClassicConfiguration(this.configuration);
    }

    public MigrateResult migrate() throws FlywayException {
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            if (this.configuration.isValidateOnMigrate()) {
                ArrayList<ValidatePattern> ignorePatterns = new ArrayList<ValidatePattern>(Arrays.asList(this.configuration.getIgnoreMigrationPatterns()));
                ignorePatterns.add(ValidatePattern.fromPattern("*:pending"));
                ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, ignorePatterns.toArray(new ValidatePattern[0]));
                if (!validateResult.validationSuccessful && !this.configuration.isCleanOnValidationError()) {
                    throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
                }
            }
            if (this.configuration.isCreateSchemas()) {
                new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(false);
            } else if (!defaultSchema.exists()) {
                LOG.warn("The configuration option 'createSchemas' is false.\nHowever, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://flywaydb.org/documentation/concepts/migrations.html#the-createschemas-option-and-the-schema-history-table");
            }
            if (!schemaHistory.exists()) {
                ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                for (Schema schema : schemas) {
                    if (!schema.exists() || schema.empty()) continue;
                    nonEmptySchemas.add(schema);
                }
                if (!nonEmptySchemas.isEmpty()) {
                    if (this.configuration.isBaselineOnMigrate()) {
                        this.doBaseline(schemaHistory, callbackExecutor, database);
                    } else if (!schemaHistory.exists()) {
                        throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.", ErrorCode.NON_EMPTY_SCHEMA_WITHOUT_SCHEMA_HISTORY_TABLE);
                    }
                }
                schemaHistory.create(false);
            }
            MigrateResult result = new DbMigrate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, callbackExecutor).migrate();
            callbackExecutor.onOperationFinishEvent(Event.AFTER_MIGRATE_OPERATION_FINISH, result);
            return result;
        }, true);
    }

    public MigrationInfoService info() {
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            MigrationInfoService migrationInfoService = new DbInfo(migrationResolver, schemaHistory, this.configuration, database, callbackExecutor, schemas).info();
            callbackExecutor.onOperationFinishEvent(Event.AFTER_INFO_OPERATION_FINISH, migrationInfoService.getInfoResult());
            return migrationInfoService;
        }, true);
    }

    public CleanResult clean() {
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            CleanResult cleanResult = this.doClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor);
            callbackExecutor.onOperationFinishEvent(Event.AFTER_CLEAN_OPERATION_FINISH, cleanResult);
            return cleanResult;
        }, false);
    }

    public void validate() throws FlywayException {
        this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration.getIgnoreMigrationPatterns());
            callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
            LOG.notice("Automate migration testing for Database CI with Flyway Hub. Visit https://flywaydb.org/get-started-with-hub");
            if (!validateResult.validationSuccessful && !this.configuration.isCleanOnValidationError()) {
                throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
            }
            return null;
        }, true);
    }

    public ValidateResult validateWithResult() throws FlywayException {
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration.getIgnoreMigrationPatterns());
            callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
            return validateResult;
        }, true);
    }

    public BaselineResult baseline() throws FlywayException {
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            if (this.configuration.isCreateSchemas()) {
                new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(true);
            } else {
                LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://flywaydb.org/documentation/concepts/migrations.html#the-createschemas-option-and-the-schema-history-table");
            }
            BaselineResult baselineResult = this.doBaseline(schemaHistory, callbackExecutor, database);
            callbackExecutor.onOperationFinishEvent(Event.AFTER_BASELINE_OPERATION_FINISH, baselineResult);
            return baselineResult;
        }, false);
    }

    public RepairResult repair() throws FlywayException {
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            RepairResult repairResult = new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor, this.configuration).repair();
            callbackExecutor.onOperationFinishEvent(Event.AFTER_REPAIR_OPERATION_FINISH, repairResult);
            return repairResult;
        }, true);
    }

    public UndoResult undo() throws FlywayException {
        try {
            return (UndoResult)this.runCommand("undo", Collections.emptyList());
        }
        catch (FlywayException e) {
            if (e.getMessage().startsWith("No command extension found")) {
                throw new FlywayException("The command 'undo' was not recognized. Make sure you have added 'flyway-proprietary' as a dependency.", e);
            }
            throw e;
        }
    }

    private OperationResult runCommand(String command, List<String> flags) {
        return this.configuration.getPluginRegister().getPlugins(CommandExtension.class).stream().filter(commandExtension -> commandExtension.handlesCommand(command)).findFirst().map(commandExtension -> commandExtension.handle(command, this.configuration, flags)).orElseThrow(() -> new FlywayException("No command extension found to handle command: " + command));
    }

    private CleanResult doClean(Database database, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor) {
        return new DbClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration).clean();
    }

    private ValidateResult doValidate(Database database, CompositeMigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor, ValidatePattern[] ignorePatterns) {
        ValidateResult validateResult = new DbValidate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, callbackExecutor, ignorePatterns).validate();
        if (!validateResult.validationSuccessful && this.configuration.isCleanOnValidationError()) {
            this.doClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor);
        }
        return validateResult;
    }

    private BaselineResult doBaseline(SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Database database) {
        return new DbBaseline(schemaHistory, this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor, database).baseline();
    }
}

