/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.telemetry;

import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.RgDomainChecker;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.FingerprintUtils;

public class TelemetryEventFactory {
    public static Map<String, String> createUpdateCheckRequest(Configuration config, List<String> verbs, String dbEngine, String dbVersion) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("currentVersion", VersionPrinter.getVersion());
        properties.put("operatingSystem", System.getProperty("os.name"));
        properties.put("fingerprint", FingerprintUtils.getFingerprint(config));
        properties.put("timeStamp", Instant.now().toString());
        properties.put("edition", VersionPrinter.EDITION.name());
        properties.put("verbs", Arrays.toString(verbs.toArray()));
        properties.put("engine", dbEngine);
        properties.put("version", dbVersion);
        properties.put("fromRedgate", Boolean.toString(TelemetryEventFactory.isInRedgate(config)));
        return properties;
    }

    private static boolean isInRedgate(Configuration config) {
        if (System.getenv("RGDOMAIN") != null) {
            return true;
        }
        return config.getPluginRegister().getPlugins(RgDomainChecker.class).stream().anyMatch(c -> c.isInDomain(config));
    }
}

