/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.plugin.PluginRegister;

public class DatabaseTypeRegister {
    private static final Log LOG = LogFactory.getLog(DatabaseTypeRegister.class);
    private static final List<DatabaseType> SORTED_DATABASE_TYPES = new PluginRegister().getPlugins(DatabaseType.class).stream().sorted().collect(Collectors.toList());

    public static DatabaseType getDatabaseTypeForUrl(String url) {
        List<DatabaseType> typesAcceptingUrl = DatabaseTypeRegister.getDatabaseTypesForUrl(url);
        if (typesAcceptingUrl.size() > 0) {
            if (typesAcceptingUrl.size() > 1) {
                StringBuilder builder = new StringBuilder();
                for (DatabaseType type : typesAcceptingUrl) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(type.getName());
                }
                LOG.debug("Multiple databases found that handle url '" + DatabaseTypeRegister.redactJdbcUrl(url) + "': " + builder);
            }
            return typesAcceptingUrl.get(0);
        }
        throw new FlywayException("No database found to handle " + DatabaseTypeRegister.redactJdbcUrl(url));
    }

    private static List<DatabaseType> getDatabaseTypesForUrl(String url) {
        ArrayList<DatabaseType> typesAcceptingUrl = new ArrayList<DatabaseType>();
        for (DatabaseType type : SORTED_DATABASE_TYPES) {
            if (!type.handlesJDBCUrl(url)) continue;
            typesAcceptingUrl.add(type);
        }
        return typesAcceptingUrl;
    }

    public static String redactJdbcUrl(String url) {
        List<DatabaseType> types = DatabaseTypeRegister.getDatabaseTypesForUrl(url);
        if (types.isEmpty()) {
            url = DatabaseTypeRegister.redactJdbcUrl(url, BaseDatabaseType.getDefaultJDBCCredentialsPattern());
        } else {
            for (DatabaseType type : types) {
                Pattern dbPattern = type.getJDBCCredentialsPattern();
                if (dbPattern == null) continue;
                url = DatabaseTypeRegister.redactJdbcUrl(url, dbPattern);
            }
        }
        return url;
    }

    private static String redactJdbcUrl(String url, Pattern pattern) {
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String password = matcher.group(1);
            return url.replace(password, "********");
        }
        return url;
    }

    public static DatabaseType getDatabaseTypeForConnection(Connection connection) {
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        for (DatabaseType type : SORTED_DATABASE_TYPES) {
            if (!type.handlesDatabaseProductNameAndVersion(databaseProductName, databaseProductVersion, connection)) continue;
            return type;
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }
}

