/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;

public class PropertyResolverContextImpl
implements PropertyResolverContext {
    private final Map<String, PropertyResolver> resolvers;
    private final Map<String, Map<String, String>> resolverProperties;

    @Override
    public String resolveValue(String value) {
        String resolverParam;
        if (value == null || !value.startsWith("$")) {
            return value;
        }
        if (value.startsWith("$$")) {
            return value.substring(1);
        }
        int splitIndex = value.indexOf(".");
        String resolverName = splitIndex != -1 ? value.substring(1, splitIndex) : value.substring(1);
        String string = resolverParam = splitIndex != -1 ? value.substring(splitIndex + 1) : null;
        if (!this.resolvers.containsKey(resolverName)) {
            throw new FlywayException("Unknown resolver: " + resolverName);
        }
        return this.resolvers.get(resolverName).resolve(resolverParam, this);
    }

    @Override
    public String resolveProperty(String resolverName, String propertyName) {
        if (this.resolverProperties == null) {
            return null;
        }
        Map<String, String> properties = this.resolverProperties.get(resolverName);
        if (properties == null) {
            return null;
        }
        return this.resolveValue(properties.get(propertyName));
    }

    public PropertyResolverContextImpl(Map<String, PropertyResolver> resolvers, Map<String, Map<String, String>> resolverProperties) {
        this.resolvers = resolvers;
        this.resolverProperties = resolverProperties;
    }
}

