/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;

public class GoogleSecretsResolver
implements PropertyResolver {
    @Override
    public String getName() {
        return "googlesecrets";
    }

    @Override
    public String resolve(String key, PropertyResolverContext context) {
        String string;
        block8: {
            String project = context.resolveProperty(this.getName(), "project");
            SecretManagerServiceClient client = SecretManagerServiceClient.create();
            try {
                SecretVersionName secretVersionName = SecretVersionName.of((String)project, (String)key, (String)"latest");
                AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
                string = response.getPayload().getData().toStringUtf8();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FlywayException("Could not resolve key: " + key, e);
                }
            }
            client.close();
        }
        return string;
    }
}

