/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.flywaydb.core.internal.util.Pair;

public class StringUtils {
    private static final String WHITESPACE_CHARS = " \t\n\f\r";

    public static String trimOrPad(String str, int length) {
        return StringUtils.trimOrPad(str, length, ' ');
    }

    public static String trimOrPad(String str, int length, char padChar) {
        StringBuilder result = str == null ? new StringBuilder() : new StringBuilder(str);
        if (result.length() > length) {
            return result.substring(0, length);
        }
        while (result.length() < length) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static String trimOrLeftPad(String str, int length, char padChar) {
        if (str == null) {
            str = "";
        }
        if (str.length() > length) {
            return str.substring(0, length);
        }
        return StringUtils.leftPad(str, length, padChar);
    }

    public static String leftPad(String original, int length, char padChar) {
        StringBuilder result = new StringBuilder(original);
        while (result.length() < length) {
            result.insert(0, padChar);
        }
        return result.toString();
    }

    public static String rightPad(String original, int length, char padChar) {
        StringBuilder result = new StringBuilder(original);
        while (result.length() < length) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static String collapseWhitespace(String str) {
        StringBuilder result = new StringBuilder();
        int previous = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (StringUtils.isCharAnyOf(c, WHITESPACE_CHARS)) {
                if (previous != 32) {
                    result.append(' ');
                }
                previous = 32;
                continue;
            }
            result.append(c);
            previous = c;
        }
        return result.toString();
    }

    public static String left(String str, int count) {
        if (str == null) {
            return null;
        }
        if (str.length() < count) {
            return str;
        }
        return str.substring(0, count);
    }

    public static String replaceAll(String str, String originalToken, String replacementToken) {
        return str.replaceAll(Pattern.quote(originalToken), Matcher.quoteReplacement(replacementToken));
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static String arrayToCommaDelimitedString(Object[] strings) {
        return StringUtils.arrayToDelimitedString(",", strings);
    }

    public static String arrayToDelimitedString(String delimiter, Object[] strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(strings[i]);
        }
        return builder.toString();
    }

    public static boolean hasText(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static String[] tokenizeToStringArray(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        return StringUtils.tokenizeToStringCollection(str, delimiter).toArray(new String[0]);
    }

    public static List<String> tokenizeToStringCollection(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        return Arrays.stream(str.split(delimiter)).map(String::trim).collect(Collectors.toList());
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String collectionToCommaDelimitedString(Collection<?> collection) {
        return StringUtils.collectionToDelimitedString(collection, ", ");
    }

    public static String collectionToDelimitedString(Collection<?> collection, String delimiter) {
        if (collection == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char character) {
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && character == buf.charAt(0)) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static boolean startsAndEndsWith(String str, String prefix, String ... suffixes) {
        if (StringUtils.hasLength(prefix) && !str.startsWith(prefix)) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!str.toUpperCase().endsWith(suffix.toUpperCase()) || str.length() <= (prefix + suffix).length()) continue;
            return true;
        }
        return false;
    }

    public static String wrap(String str, int lineSize) {
        if (str.length() < lineSize) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        int oldPos = 0;
        for (int pos = lineSize; pos < str.length(); pos += lineSize) {
            result.append(str, oldPos, pos).append("\n");
            oldPos = pos;
        }
        result.append(str.substring(oldPos));
        return result.toString();
    }

    public static String wordWrap(String str, int lineSize) {
        if (str.length() < lineSize) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        int oldPos = 0;
        int pos = lineSize;
        while (pos < str.length()) {
            if (Character.isWhitespace(str.charAt(pos))) {
                ++pos;
                continue;
            }
            String part = str.substring(oldPos, pos);
            int spacePos = part.lastIndexOf(32);
            if (spacePos > 0) {
                pos = oldPos + spacePos + 1;
            }
            result.append(str.substring(oldPos, pos).trim()).append("\n");
            oldPos = pos;
            pos += lineSize;
        }
        result.append(str.substring(oldPos));
        return result.toString();
    }

    public static boolean isCharAnyOf(char c, String chars) {
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static Pair<String, String> getFileNameAndExtension(String path) {
        String[] foldersSplit = path.split("[|/\\\\]");
        String fileNameAndExtension = foldersSplit[foldersSplit.length - 1];
        String[] nameExtensionSplit = fileNameAndExtension.split("\\.");
        if (nameExtensionSplit.length < 2) {
            return Pair.of(fileNameAndExtension, "");
        }
        return Pair.of(nameExtensionSplit[nameExtensionSplit.length - 2], nameExtensionSplit[nameExtensionSplit.length - 1]);
    }

    public static Pair<String, String> splitAtFirstSeparator(String input, String separator) {
        int separatorIndex = input.indexOf(separator);
        if (separatorIndex >= 0) {
            return Pair.of(input.substring(0, separatorIndex), input.substring(separatorIndex + separator.length()));
        }
        return Pair.of(input, "");
    }

    private StringUtils() {
    }
}

