/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.logging;

import java.util.ArrayList;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.internal.logging.EvolvingLog;
import org.flywaydb.core.internal.logging.apachecommons.ApacheCommonsLogCreator;
import org.flywaydb.core.internal.logging.buffered.BufferedLogCreator;
import org.flywaydb.core.internal.logging.javautil.JavaUtilLogCreator;
import org.flywaydb.core.internal.logging.log4j2.Log4j2LogCreator;
import org.flywaydb.core.internal.logging.multi.MultiLogCreator;
import org.flywaydb.core.internal.logging.slf4j.Slf4jLogCreator;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;

public class LogFactory {
    private static final Object $LOCK = new Object[0];
    private static volatile LogCreator logCreator;
    private static LogCreator fallbackLogCreator;
    private static Configuration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogCreator(LogCreator logCreator) {
        Object object = $LOCK;
        synchronized (object) {
            LogFactory.logCreator = logCreator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFallbackLogCreator(LogCreator fallbackLogCreator) {
        Object object = $LOCK;
        synchronized (object) {
            LogFactory.fallbackLogCreator = fallbackLogCreator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfiguration(Configuration configuration) {
        Object object = $LOCK;
        synchronized (object) {
            LogFactory.configuration = configuration;
            logCreator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(Class<?> clazz) {
        Object object = $LOCK;
        synchronized (object) {
            if (logCreator == null) {
                logCreator = LogFactory.getLogCreator(LogFactory.class.getClassLoader(), fallbackLogCreator);
            }
            return new EvolvingLog(logCreator.createLogger(clazz), clazz);
        }
    }

    private static LogCreator getLogCreator(ClassLoader classLoader, LogCreator fallbackLogCreator) {
        if (configuration == null) {
            return new BufferedLogCreator();
        }
        String[] loggers = configuration.getLoggers();
        ArrayList<LogCreator> logCreators = new ArrayList<LogCreator>();
        block15: for (String logger : loggers) {
            switch (logger.toLowerCase()) {
                case "auto": {
                    logCreators.add(LogFactory.autoDetectLogCreator(classLoader, fallbackLogCreator));
                    continue block15;
                }
                case "maven": 
                case "console": {
                    logCreators.add(fallbackLogCreator);
                    continue block15;
                }
                case "slf4j": {
                    logCreators.add((LogCreator)ClassUtils.instantiate(Slf4jLogCreator.class.getName(), classLoader));
                    continue block15;
                }
                case "log4j2": {
                    logCreators.add((LogCreator)ClassUtils.instantiate(Log4j2LogCreator.class.getName(), classLoader));
                    continue block15;
                }
                case "apache-commons": {
                    logCreators.add((LogCreator)ClassUtils.instantiate(ApacheCommonsLogCreator.class.getName(), classLoader));
                    continue block15;
                }
                default: {
                    logCreators.add((LogCreator)ClassUtils.instantiate(logger, classLoader));
                }
            }
        }
        return new MultiLogCreator(logCreators);
    }

    private static LogCreator autoDetectLogCreator(ClassLoader classLoader, LogCreator fallbackLogCreator) {
        FeatureDetector featureDetector = new FeatureDetector(classLoader);
        if (featureDetector.isSlf4jAvailable()) {
            return (LogCreator)ClassUtils.instantiate(Slf4jLogCreator.class.getName(), classLoader);
        }
        if (featureDetector.isLog4J2Available()) {
            return (LogCreator)ClassUtils.instantiate(Log4j2LogCreator.class.getName(), classLoader);
        }
        if (featureDetector.isApacheCommonsLoggingAvailable()) {
            return (LogCreator)ClassUtils.instantiate(ApacheCommonsLogCreator.class.getName(), classLoader);
        }
        if (fallbackLogCreator == null) {
            return new JavaUtilLogCreator();
        }
        return fallbackLogCreator;
    }

    private LogFactory() {
    }
}

