/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.license.VersionPrinter;

public class LinkUtils {
    public static String createFlywayDbWebsiteLink(String url, String ref) {
        String link = LinkUtils.createFlywayDbWebsiteLink(url);
        link = link.contains("?ref=v") ? link + "_" + ref : link + "?ref=" + ref;
        return LinkUtils.sanitize(link);
    }

    public static String createFlywayDbWebsiteLink(String url) {
        String link = "https://flywaydb.org/" + url;
        try {
            MigrationVersion current = MigrationVersion.fromVersion(VersionPrinter.getVersion());
            link = link + "?ref=v" + current;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LinkUtils.sanitize(link);
    }

    private static String sanitize(String link) {
        return link.replace(" ", "%20");
    }
}

