/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.base;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DefaultExecutionStrategy;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.ExecutionTemplate;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.jdbc.TransactionalExecutionTemplate;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;

public abstract class DatabaseType {
    protected static final Log LOG = LogFactory.getLog(DatabaseType.class);
    protected static final String APPLICATION_NAME = "Flyway by Redgate";

    public abstract String getName();

    public abstract int getNullType();

    public abstract boolean handlesJDBCUrl(String var1);

    public abstract String getDriverClass(String var1, ClassLoader var2);

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        return null;
    }

    public abstract boolean handlesDatabaseProductNameAndVersion(String var1, String var2, Connection var3);

    public Database createDatabase(Configuration configuration, boolean printInfo, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        String databaseProductName = jdbcConnectionFactory.getProductName();
        if (printInfo) {
            LOG.info("Database: " + jdbcConnectionFactory.getJdbcUrl() + " (" + databaseProductName + ")");
            LOG.debug("Driver  : " + jdbcConnectionFactory.getDriverInfo());
        }
        Database database = this.createDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
        String intendedCurrentSchema = configuration.getDefaultSchema();
        if (!database.supportsChangingCurrentSchema() && intendedCurrentSchema != null) {
            LOG.warn(databaseProductName + " does not support setting the schema for the current session. Default schema will NOT be changed to " + intendedCurrentSchema + " !");
        }
        return database;
    }

    public abstract Database createDatabase(Configuration var1, JdbcConnectionFactory var2, StatementInterceptor var3);

    public abstract Parser createParser(Configuration var1, ResourceProvider var2, ParsingContext var3);

    public SqlScriptFactory createSqlScriptFactory(final Configuration configuration, final ParsingContext parsingContext) {
        return new SqlScriptFactory(){

            @Override
            public SqlScript createSqlScript(LoadableResource resource, boolean mixed, ResourceProvider resourceProvider) {
                return new ParserSqlScript(DatabaseType.this.createParser(configuration, resourceProvider, parsingContext), resource, SqlScriptMetadata.getMetadataResource(resourceProvider, resource), mixed);
            }
        };
    }

    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, final CallbackExecutor callbackExecutor, final StatementInterceptor statementInterceptor) {
        boolean supportsBatch;
        final boolean finalSupportsBatch = supportsBatch = false;
        final DatabaseType thisRef = this;
        return new SqlScriptExecutorFactory(){

            @Override
            public SqlScriptExecutor createSqlScriptExecutor(Connection connection, boolean undo, boolean batch, boolean outputQueryResults) {
                return new DefaultSqlScriptExecutor(new JdbcTemplate(connection, thisRef), callbackExecutor, undo, finalSupportsBatch && batch, outputQueryResults, statementInterceptor);
            }
        };
    }

    public DatabaseExecutionStrategy createExecutionStrategy(Connection connection) {
        return new DefaultExecutionStrategy();
    }

    public ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        return new TransactionalExecutionTemplate(connection, rollbackOnException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectVersionOutput(Connection connection) {
        String result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT version()");
            resultSet = statement.executeQuery();
            result = null;
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            return string;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
    }

    public void setConfigConnectionProps(Configuration config, Properties props, ClassLoader classLoader) {
    }

    public void shutdownDatabase(String url, Driver driver) {
    }

    public boolean detectUserRequiredByUrl(String url) {
        return true;
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return true;
    }
}

