/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.cloud.s3;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.s3.AwsS3Resource;
import org.flywaydb.core.internal.scanner.cloud.CloudScanner;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3Scanner
extends CloudScanner {
    private static final Log LOG = LogFactory.getLog(AwsS3Scanner.class);

    public AwsS3Scanner(Charset encoding) {
        super(encoding);
    }

    @Override
    public Collection<LoadableResource> scanForResources(Location location) {
        if (System.getenv("AWS_REGION") == null || System.getenv("AWS_ACCESS_KEY_ID") == null || System.getenv("AWS_SECRET_ACCESS_KEY") == null) {
            LOG.error("Can't read location " + location + "; AWS_REGION, AWS_ACCESS_KEY_ID or AWS_SECRET_ACCESS_KEY environment variable not set");
            return Collections.emptyList();
        }
        String bucketName = this.getBucketName(location);
        String prefix = this.getPrefix(bucketName, location.getPath());
        S3Client s3Client = S3Client.create();
        try {
            ListObjectsV2Request.Builder builder = ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix);
            ListObjectsV2Request request = (ListObjectsV2Request)builder.build();
            ListObjectsV2Response listObjectResult = s3Client.listObjectsV2(request);
            return this.getLoadableResources(bucketName, listObjectResult);
        }
        catch (SdkClientException e) {
            LOG.error("Skipping s3 location:" + bucketName + prefix + " due to error: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private Collection<LoadableResource> getLoadableResources(String bucketName, ListObjectsV2Response listObjectResult) {
        List objectSummaries = listObjectResult.contents();
        TreeSet<LoadableResource> resources = new TreeSet<LoadableResource>();
        for (S3Object objectSummary : objectSummaries) {
            LOG.debug("Found Amazon S3 resource: " + bucketName.concat("/").concat(objectSummary.key()));
            resources.add(new AwsS3Resource(bucketName, objectSummary, this.encoding));
        }
        return resources;
    }
}

