/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.UndoResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.DefaultCallbackExecutor;
import org.flywaydb.core.internal.callback.NoopCallbackExecutor;
import org.flywaydb.core.internal.callback.SqlScriptCallbackFactory;
import org.flywaydb.core.internal.clazz.NoopClassProvider;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.DatabaseType;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.resource.NoopResourceProvider;
import org.flywaydb.core.internal.resource.ResourceNameValidator;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private boolean dbConnectionInfoPrinted;
    private ConfigurationValidator configurationValidator = new ConfigurationValidator();
    private ResourceNameValidator resourceNameValidator = new ResourceNameValidator();
    private ResourceNameCache resourceNameCache = new ResourceNameCache();
    private final LocationScannerCache locationScannerCache = new LocationScannerCache();

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
        this.configuration.loadCallbackLocation("db/callback", false);
    }

    public Configuration getConfiguration() {
        return new ClassicConfiguration(this.configuration);
    }

    public MigrateResult migrate() throws FlywayException {
        return this.execute(new Command<MigrateResult>(){

            @Override
            public MigrateResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                if (Flyway.this.configuration.isValidateOnMigrate()) {
                    ValidateResult validateResult = Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, true);
                    if (!validateResult.validationSuccessful && !Flyway.this.configuration.isCleanOnValidationError()) {
                        throw new FlywayException("Validate failed: " + validateResult.validationError);
                    }
                }
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (!schema.exists() || schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.configuration.isBaselineOnMigrate()) {
                            Flyway.this.doBaseline(schemaHistory, callbackExecutor, database);
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                        }
                    } else {
                        if (Flyway.this.configuration.getCreateSchemas()) {
                            new DbSchemas(database, schemas, schemaHistory).create(false);
                        } else {
                            LOG.warn("The configuration option 'createSchemas' is false.\nHowever the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee http://flywaydb.org/documentation/migrations#the-createschemas-option-and-the-schema-history-table)");
                        }
                        schemaHistory.create(false);
                    }
                }
                return new DbMigrate(database, schemaHistory, schemas, migrationResolver, Flyway.this.configuration, callbackExecutor).migrate();
            }
        }, true);
    }

    private BaselineResult doBaseline(SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Database database) {
        return new DbBaseline(schemaHistory, this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor, database).baseline();
    }

    public UndoResult undo() throws FlywayException {
        throw new FlywayTeamsUpgradeRequiredException("undo");
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                String validationError = ((Flyway)Flyway.this).doValidate((Database)database, (MigrationResolver)migrationResolver, (SchemaHistory)schemaHistory, (Schema[])schemas, (CallbackExecutor)callbackExecutor, (boolean)((Flyway)Flyway.this).configuration.isIgnorePendingMigrations()).validationError;
                if (validationError != null && !Flyway.this.configuration.isCleanOnValidationError()) {
                    throw new FlywayException("Validate failed: " + validationError);
                }
                return null;
            }
        }, true);
    }

    public ValidateResult validateWithResult() throws FlywayException {
        return this.execute(new Command<ValidateResult>(){

            @Override
            public ValidateResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                return Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, Flyway.this.configuration.isIgnorePendingMigrations());
            }
        }, true);
    }

    private ValidateResult doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor, boolean ignorePending) {
        ValidateResult validateResult = new DbValidate(database, schemaHistory, schemas, migrationResolver, this.configuration, ignorePending, callbackExecutor).validate();
        if (!validateResult.validationSuccessful && this.configuration.isCleanOnValidationError()) {
            this.doClean(database, schemaHistory, schemas, callbackExecutor);
        }
        return validateResult;
    }

    private CleanResult doClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor) {
        return new DbClean(database, schemaHistory, schemas, callbackExecutor, this.configuration.isCleanDisabled()).clean();
    }

    public CleanResult clean() {
        return this.execute(new Command<CleanResult>(){

            @Override
            public CleanResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                return Flyway.this.doClean(database, schemaHistory, schemas, callbackExecutor);
            }
        }, false);
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                return new DbInfo(migrationResolver, schemaHistory, Flyway.this.configuration, callbackExecutor, schemas).info();
            }
        }, true);
    }

    public BaselineResult baseline() throws FlywayException {
        return this.execute(new Command<BaselineResult>(){

            @Override
            public BaselineResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                if (Flyway.this.configuration.getCreateSchemas()) {
                    new DbSchemas(database, schemas, schemaHistory).create(true);
                } else {
                    LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee http://flywaydb.org/documentation/migrations#the-createschemas-option-and-the-schema-history-table");
                }
                return Flyway.this.doBaseline(schemaHistory, callbackExecutor, database);
            }
        }, false);
    }

    public RepairResult repair() throws FlywayException {
        return this.execute(new Command<RepairResult>(){

            @Override
            public RepairResult execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
                return new DbRepair(database, migrationResolver, schemaHistory, schemas, callbackExecutor, Flyway.this.configuration).repair();
            }
        }, true);
    }

    private MigrationResolver createMigrationResolver(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext) {
        return new CompositeMigrationResolver(resourceProvider, classProvider, this.configuration, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext, this.configuration.getResolvers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command, boolean scannerRequired) {
        T result;
        VersionPrinter.printVersion();
        this.configurationValidator.validate(this.configuration);
        StatementInterceptor statementInterceptor = null;
        Pair<ResourceProvider, ClassProvider<JavaMigration>> resourceProviderClassProviderPair = this.createResourceAndClassProviders(scannerRequired);
        final ResourceProvider resourceProvider = resourceProviderClassProviderPair.getLeft();
        ClassProvider<JavaMigration> classProvider = resourceProviderClassProviderPair.getRight();
        if (this.configuration.isValidateMigrationNaming()) {
            this.resourceNameValidator.validateSQLMigrationNaming(resourceProvider, this.configuration);
        }
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(this.configuration.getDataSource(), this.configuration.getConnectRetries(), statementInterceptor);
        DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        ParsingContext parsingContext = new ParsingContext();
        final SqlScriptFactory sqlScriptFactory = databaseType.createSqlScriptFactory(this.configuration, parsingContext);
        final SqlScriptExecutorFactory noCallbackSqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, NoopCallbackExecutor.INSTANCE, null);
        jdbcConnectionFactory.setConnectionInitializer(new JdbcConnectionFactory.ConnectionInitializer(){

            @Override
            public void initialize(JdbcConnectionFactory jdbcConnectionFactory, java.sql.Connection connection) {
                if (Flyway.this.configuration.getInitSql() == null) {
                    return;
                }
                StringResource resource = new StringResource(Flyway.this.configuration.getInitSql());
                SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, true, resourceProvider);
                boolean outputQueryResults = false;
                noCallbackSqlScriptExecutorFactory.createSqlScriptExecutor(connection, false, false, outputQueryResults).execute(sqlScript);
            }
        });
        Database database = null;
        try {
            database = databaseType.createDatabase(this.configuration, !this.dbConnectionInfoPrinted, jdbcConnectionFactory, statementInterceptor);
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Pair<Schema, List<Schema>> schemas = this.prepareSchemas(database);
            Schema defaultSchema = schemas.getLeft();
            parsingContext.populate(database, this.configuration);
            database.ensureSupported();
            DefaultCallbackExecutor callbackExecutor = new DefaultCallbackExecutor(this.configuration, database, defaultSchema, this.prepareCallbacks(database, resourceProvider, jdbcConnectionFactory, sqlScriptFactory, statementInterceptor, defaultSchema));
            SqlScriptExecutorFactory sqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor, statementInterceptor);
            result = command.execute(this.createMigrationResolver(resourceProvider, classProvider, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext), SchemaHistoryFactory.getSchemaHistory(this.configuration, noCallbackSqlScriptExecutorFactory, sqlScriptFactory, database, defaultSchema, statementInterceptor), database, schemas.getRight().toArray(new Schema[0]), callbackExecutor, statementInterceptor);
        }
        catch (Throwable throwable) {
            IOUtils.close(database);
            this.showMemoryUsage();
            throw throwable;
        }
        IOUtils.close(database);
        this.showMemoryUsage();
        return result;
    }

    private Pair<ResourceProvider, ClassProvider<JavaMigration>> createResourceAndClassProviders(boolean scannerRequired) {
        ClassProvider classProvider;
        ResourceProvider resourceProvider;
        if (!scannerRequired && this.configuration.isSkipDefaultResolvers() && this.configuration.isSkipDefaultCallbacks()) {
            resourceProvider = NoopResourceProvider.INSTANCE;
            classProvider = NoopClassProvider.INSTANCE;
        } else if (this.configuration.getResourceProvider() != null && this.configuration.getJavaMigrationClassProvider() != null) {
            resourceProvider = this.configuration.getResourceProvider();
            classProvider = this.configuration.getJavaMigrationClassProvider();
        } else {
            boolean stream = false;
            Scanner<JavaMigration> scanner = new Scanner<JavaMigration>(JavaMigration.class, Arrays.asList(this.configuration.getLocations()), this.configuration.getClassLoader(), this.configuration.getEncoding(), stream, this.resourceNameCache, this.locationScannerCache);
            resourceProvider = scanner;
            classProvider = scanner;
            if (this.configuration.getResourceProvider() != null) {
                resourceProvider = this.configuration.getResourceProvider();
            }
            if (this.configuration.getJavaMigrationClassProvider() != null) {
                classProvider = this.configuration.getJavaMigrationClassProvider();
            }
        }
        return Pair.of(resourceProvider, classProvider);
    }

    private void showMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        long totalMB = total / 0x100000L;
        long usedMB = used / 0x100000L;
        LOG.debug("Memory usage: " + usedMB + " of " + totalMB + "M");
    }

    private Pair<Schema, List<Schema>> prepareSchemas(Database database) {
        Object[] schemaNames;
        Object defaultSchemaName = this.configuration.getDefaultSchema();
        if (!this.isDefaultSchemaValid((String)defaultSchemaName, (String[])(schemaNames = this.configuration.getSchemas()))) {
            throw new FlywayException("The defaultSchema property is specified but is not a member of the schemas property");
        }
        LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(schemaNames));
        LOG.debug("Default schema: " + (String)defaultSchemaName);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        if (schemaNames.length == 0) {
            Schema schema = ((Connection)database.getMainConnection()).getCurrentSchema();
            if (schema == null) {
                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the defaultSchema property!");
            }
            schemas.add(schema);
        } else {
            for (Object schemaName : schemaNames) {
                schemas.add(((Connection)database.getMainConnection()).getSchema((String)schemaName));
            }
        }
        if (defaultSchemaName == null && schemaNames.length > 0) {
            defaultSchemaName = schemaNames[0];
        }
        Schema schema = defaultSchemaName != null ? ((Connection)database.getMainConnection()).getSchema((String)defaultSchemaName) : ((Connection)database.getMainConnection()).getCurrentSchema();
        return Pair.of(schema, schemas);
    }

    private boolean isDefaultSchemaValid(String defaultSchema, String[] schemas) {
        if (defaultSchema == null) {
            return true;
        }
        for (String schema : schemas) {
            if (!defaultSchema.equals(schema)) continue;
            return true;
        }
        return false;
    }

    private List<Callback> prepareCallbacks(Database database, ResourceProvider resourceProvider, JdbcConnectionFactory jdbcConnectionFactory, SqlScriptFactory sqlScriptFactory, StatementInterceptor statementInterceptor, Schema schema) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>();
        NoopCallbackExecutor callbackExecutor = NoopCallbackExecutor.INSTANCE;
        effectiveCallbacks.addAll(Arrays.asList(this.configuration.getCallbacks()));
        if (!this.configuration.isSkipDefaultCallbacks()) {
            SqlScriptExecutorFactory sqlScriptExecutorFactory = jdbcConnectionFactory.getDatabaseType().createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor, statementInterceptor);
            effectiveCallbacks.addAll(new SqlScriptCallbackFactory(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, this.configuration).getCallbacks());
        }
        return effectiveCallbacks;
    }

    static interface Command<T> {
        public T execute(MigrationResolver var1, SchemaHistory var2, Database var3, Schema[] var4, CallbackExecutor var5, StatementInterceptor var6);
    }
}

