/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.sql.SQLException;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DatabaseFactory;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.util.SqlCallable;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final SqlScript sqlScript;

    SqlMigrationExecutor(SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScript sqlScript) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.sqlScript = sqlScript;
    }

    @Override
    public void execute(final Context context) throws SQLException {
        DatabaseExecutionStrategy strategy = DatabaseFactory.createExecutionStrategy(context.getConnection());
        strategy.execute(new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                SqlMigrationExecutor.this.executeOnce(context);
                return true;
            }
        });
    }

    private void executeOnce(Context context) {
        this.sqlScriptExecutorFactory.createSqlScriptExecutor(context.getConnection()).execute(this.sqlScript);
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.sqlScript.executeInTransaction();
    }
}

