/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.h2;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.h2.H2Database;
import org.flywaydb.core.internal.database.h2.H2Schema;

public class H2Connection
extends org.flywaydb.core.internal.database.base.Connection<H2Database> {
    H2Connection(H2Database database, Connection connection) {
        super(database, connection);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((H2Database)this.database).quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new H2Schema(this.jdbcTemplate, (H2Database)this.database, name);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("CALL SCHEMA()", new String[0]);
    }
}

