/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public enum DatabaseType {
    COCKROACHDB("CockroachDB", 0, false),
    DB2("DB2", 12, true),
    DERBY("Derby", 12, true),
    FIREBIRD("Firebird", 0, true),
    H2("H2", 12, true),
    HSQLDB("HSQLDB", 12, true),
    INFORMIX("Informix", 12, true),
    MARIADB("MariaDB", 12, true),
    MYSQL("MySQL", 12, true),
    ORACLE("Oracle", 12, true),
    POSTGRESQL("PostgreSQL", 0, true),
    REDSHIFT("Redshift", 12, true),
    SQLITE("SQLite", 12, false),
    SQLSERVER("SQL Server", 12, true),
    SYBASEASE_JTDS("Sybase ASE", 0, true),
    SYBASEASE_JCONNECT("Sybase ASE", 12, true),
    SAPHANA("SAP HANA", 12, true);

    private final String name;
    private final int nullType;
    private final boolean supportsReadOnlyTransactions;

    private DatabaseType(String name, int nullType, boolean supportsReadOnlyTransactions) {
        this.name = name;
        this.nullType = nullType;
        this.supportsReadOnlyTransactions = supportsReadOnlyTransactions;
    }

    public static DatabaseType fromJdbcConnection(Connection connection) {
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        return DatabaseType.fromDatabaseProductNameAndVersion(databaseProductName, databaseProductVersion, connection);
    }

    private static DatabaseType fromDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (databaseProductName.startsWith("Apache Derby")) {
            return DERBY;
        }
        if (databaseProductName.startsWith("SQLite")) {
            return SQLITE;
        }
        if (databaseProductName.startsWith("H2")) {
            return H2;
        }
        if (databaseProductName.contains("HSQL Database Engine")) {
            return HSQLDB;
        }
        if (databaseProductName.startsWith("Microsoft SQL Server")) {
            return SQLSERVER;
        }
        if (databaseProductName.startsWith("MariaDB") || databaseProductName.contains("MySQL") && databaseProductVersion.contains("MariaDB") || databaseProductName.contains("MySQL") && DatabaseType.getSelectVersionOutput(connection).contains("MariaDB")) {
            return MARIADB;
        }
        if (databaseProductName.contains("MySQL")) {
            return MYSQL;
        }
        if (databaseProductName.startsWith("Oracle")) {
            return ORACLE;
        }
        if (databaseProductName.startsWith("PostgreSQL")) {
            String selectVersionQueryOutput = DatabaseType.getSelectVersionOutput(connection);
            if (databaseProductName.startsWith("PostgreSQL 8") && selectVersionQueryOutput.contains("Redshift")) {
                return REDSHIFT;
            }
            if (selectVersionQueryOutput.contains("CockroachDB")) {
                return COCKROACHDB;
            }
            return POSTGRESQL;
        }
        if (databaseProductName.startsWith("DB2")) {
            return DB2;
        }
        if (databaseProductName.startsWith("ASE")) {
            return SYBASEASE_JTDS;
        }
        if (databaseProductName.startsWith("Adaptive Server Enterprise")) {
            return SYBASEASE_JCONNECT;
        }
        if (databaseProductName.startsWith("HDB")) {
            return SAPHANA;
        }
        if (databaseProductName.startsWith("Informix")) {
            return INFORMIX;
        }
        if (databaseProductName.startsWith("Firebird")) {
            return FIREBIRD;
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectVersionOutput(Connection connection) {
        String result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT version()");
            resultSet = statement.executeQuery();
            result = null;
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            return string;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getNullType() {
        return this.nullType;
    }

    public String toString() {
        return this.name;
    }
}

