/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.io.IOException;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.sqlscript.Delimiter;

public class SQLServerParser
extends Parser {
    public SQLServerParser(Configuration configuration) {
        super(configuration, 3);
    }

    @Override
    protected Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    @Override
    protected boolean isDelimiter(String peek, Delimiter delimiter) {
        return !(peek.length() < 2 || peek.charAt(0) != 'G' && peek.charAt(0) != 'g' || peek.charAt(1) != 'O' && peek.charAt(1) != 'o' || peek.length() != 2 && !Character.isWhitespace(peek.charAt(2)));
    }

    @Override
    protected String readKeyword(PeekingReader reader, Delimiter delimiter) throws IOException {
        return "" + (char)reader.read() + reader.readKeywordPart(null);
    }

    @Override
    protected Boolean detectCanExecuteInTransaction(String simplifiedStatement, List<Token> keywords) {
        String current = keywords.get(keywords.size() - 1).getText();
        if ("BACKUP".equals(current) || "RESTORE".equals(current) || "RECONFIGURE".equals(current)) {
            return false;
        }
        if (keywords.size() < 2) {
            return null;
        }
        String previous = keywords.get(keywords.size() - 2).getText();
        if ("EXEC".equals(previous) && ("SP_ADDSUBSCRIPTION".equals(current) || "SP_DROPLINKEDSRVLOGIN".equals(current) || "SP_SERVEROPTION".equals(current))) {
            return false;
        }
        if (("CREATE".equals(previous) || "ALTER".equals(previous) || "DROP".equals(previous)) && ("DATABASE".equals(current) || "FULLTEXT".equals(current))) {
            return false;
        }
        return null;
    }

    @Override
    protected int getTransactionalDetectionCutoff() {
        return Integer.MAX_VALUE;
    }
}

