/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.parser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.flywaydb.core.internal.sqlscript.Delimiter;

public class PeekingReader
extends FilterReader {
    private final int[] peekBuffer = new int[256];
    private int peekMax = 0;
    private int peekBufferOffset = 0;

    PeekingReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        ++this.peekBufferOffset;
        return super.read();
    }

    public void swallow() throws IOException {
        this.read();
    }

    public void swallow(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.read();
        }
    }

    private int peek() throws IOException {
        if (this.peekBufferOffset >= this.peekMax) {
            this.refillPeekBuffer();
        }
        return this.peekBuffer[this.peekBufferOffset];
    }

    private void refillPeekBuffer() throws IOException {
        this.mark(this.peekBuffer.length);
        this.peekMax = this.peekBuffer.length;
        this.peekBufferOffset = 0;
        for (int i = 0; i < this.peekBuffer.length; ++i) {
            int read;
            this.peekBuffer[i] = read = super.read();
            if (read != 10) continue;
            this.peekMax = i;
            break;
        }
        this.reset();
    }

    public boolean peek(char c) throws IOException {
        int r = this.peek();
        return r != -1 && c == (char)r;
    }

    public boolean peek(char c1, char c2) throws IOException {
        int r = this.peek();
        return r != -1 && (c1 == (char)r || c2 == (char)r);
    }

    public boolean peekNumeric() throws IOException {
        int r = this.peek();
        return this.isNumeric(r);
    }

    private boolean isNumeric(int r) {
        return r != -1 && (char)r >= '0' && (char)r <= '9';
    }

    public boolean peekWhitespace() throws IOException {
        int r = this.peek();
        return this.isWhitespace(r);
    }

    private boolean isWhitespace(int r) {
        return r != -1 && Character.isWhitespace((char)r);
    }

    public boolean peekKeywordPart() throws IOException {
        int r = this.peek();
        return this.isKeywordPart(r);
    }

    private boolean isKeywordPart(int r) {
        return r != -1 && ((char)r == '_' || (char)r == '$' || Character.isLetterOrDigit((char)r));
    }

    public boolean peek(String str) throws IOException {
        return str.equals(this.peek(str.length()));
    }

    public String peek(int numChars) throws IOException {
        int r;
        if (this.peekBufferOffset + numChars >= this.peekMax) {
            this.refillPeekBuffer();
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numChars && (r = this.peekBuffer[this.peekBufferOffset + i]) != -1; ++i) {
            result.append((char)r);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public void swallowUntilExcluding(char delimiter1, char delimiter2) throws IOException {
        int r;
        while (!this.peek(delimiter1, delimiter2) && (r = this.read()) != -1) {
        }
    }

    public String readUntilExcluding(char delimiter1, char delimiter2) throws IOException {
        int r;
        StringBuilder result = new StringBuilder();
        while (!this.peek(delimiter1, delimiter2) && (r = this.read()) != -1) {
            result.append((char)r);
        }
        return result.toString();
    }

    public void swallowUntilExcludingWithEscape(char delimiter, boolean selfEscape) throws IOException {
        this.swallowUntilExcludingWithEscape(delimiter, selfEscape, '\u0000');
    }

    public void swallowUntilExcludingWithEscape(char delimiter, boolean selfEscape, char escape) throws IOException {
        int r;
        while ((r = this.read()) != -1) {
            char c = (char)r;
            if (escape != '\u0000' && c == escape) {
                this.swallow();
                continue;
            }
            if (c != delimiter) continue;
            if (!selfEscape || !this.peek(delimiter)) break;
            this.swallow();
        }
    }

    public String readUntilExcludingWithEscape(char delimiter, boolean selfEscape) throws IOException {
        return this.readUntilExcludingWithEscape(delimiter, selfEscape, '\u0000');
    }

    public String readUntilExcludingWithEscape(char delimiter, boolean selfEscape, char escape) throws IOException {
        int r;
        StringBuilder result = new StringBuilder();
        while ((r = this.read()) != -1) {
            char c = (char)r;
            if (escape != '\u0000' && c == escape) {
                int r2 = this.read();
                if (r2 == -1) {
                    result.append(escape);
                    break;
                }
                char c2 = (char)r2;
                result.append(c2);
                continue;
            }
            if (c == delimiter) {
                if (!selfEscape || !this.peek(delimiter)) break;
                result.append(delimiter);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public void swallowUntilExcluding(String str) throws IOException {
        int r;
        while (!this.peek(str) && (r = this.read()) != -1) {
        }
    }

    public String readUntilExcluding(String str) throws IOException {
        int r;
        StringBuilder result = new StringBuilder();
        while (!this.peek(str) && (r = this.read()) != -1) {
            result.append((char)r);
        }
        return result.toString();
    }

    public String readUntilIncluding(char delimiter) throws IOException {
        int r;
        StringBuilder result = new StringBuilder();
        while ((r = this.read()) != -1) {
            char c = (char)r;
            result.append(c);
            if (c != delimiter) continue;
            break;
        }
        return result.toString();
    }

    public String readKeywordPart(Delimiter delimiter) throws IOException {
        StringBuilder result = new StringBuilder();
        while ((delimiter == null || !this.peek(delimiter.getDelimiter())) && this.peekKeywordPart()) {
            result.append((char)this.read());
        }
        return result.toString();
    }

    public void swallowNumeric() throws IOException {
        while (this.peekNumeric()) {
            this.swallow();
        }
        return;
    }

    public String readNumeric() throws IOException {
        StringBuilder result = new StringBuilder();
        while (this.peekNumeric()) {
            result.append((char)this.read());
        }
        return result.toString();
    }

    public String readWhitespace() throws IOException {
        StringBuilder result = new StringBuilder();
        while (this.peekWhitespace()) {
            result.append((char)this.read());
        }
        return result.toString();
    }
}

