/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSchema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class CockroachDBTable
extends Table<CockroachDBDatabase, CockroachDBSchema> {
    private static final Log LOG = LogFactory.getLog(CockroachDBTable.class);

    CockroachDBTable(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, CockroachDBSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((CockroachDBDatabase)this.database).quote(((CockroachDBSchema)this.schema).getName(), this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        if (((CockroachDBSchema)this.schema).cockroachDB1) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
        }
        return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_catalog = ?\n   AND    table_schema = 'public'\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
    }

    @Override
    protected void doLock() {
        LOG.debug("Unable to lock " + this + " as CockroachDB does not support locking. No concurrent migration supported.");
    }
}

