/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.firebird;

import java.io.IOException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class FirebirdParser
extends Parser {
    private static final String TERM_WITH_SPACES = " TERM ";

    public FirebirdParser(Configuration configuration) {
        super(configuration, 3);
    }

    @Override
    protected Token handleKeyword(PeekingReader reader, ParserContext context, int pos, int line, int col, String keyword) throws IOException {
        String possiblyTerm;
        if (FirebirdParser.keywordIs("SET", keyword) && FirebirdParser.keywordIs(TERM_WITH_SPACES, possiblyTerm = reader.peek(TERM_WITH_SPACES.length()))) {
            reader.swallow(TERM_WITH_SPACES.length());
            String newDelimiter = reader.readUntilExcluding(context.getDelimiter().getDelimiter());
            reader.swallow(context.getDelimiter().getDelimiter().length());
            return new Token(TokenType.NEW_DELIMITER, pos, line, col, newDelimiter.trim(), newDelimiter, context.getParensDepth());
        }
        return super.handleKeyword(reader, context, pos, line, col, keyword);
    }

    @Override
    protected void resetDelimiter(ParserContext context) {
    }

    @Override
    protected boolean isAlternativeStringLiteral(String peek) {
        if (peek.length() < 3) {
            return false;
        }
        char firstChar = peek.charAt(0);
        return (firstChar == 'q' || firstChar == 'Q') && peek.charAt(1) == '\'';
    }

    @Override
    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        reader.swallow(2);
        String closeQuote = this.computeAlternativeCloseQuote((char)reader.read());
        reader.swallowUntilExcluding(closeQuote);
        reader.swallow(closeQuote.length());
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    private String computeAlternativeCloseQuote(char specialChar) {
        switch (specialChar) {
            case '[': {
                return "]'";
            }
            case '(': {
                return ")'";
            }
            case '{': {
                return "}'";
            }
            case '<': {
                return ">'";
            }
        }
        return specialChar + "'";
    }
}

