/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParsedSqlStatement;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class PostgreSQLCopyParsedStatement
extends ParsedSqlStatement {
    private static final Delimiter COPY_DELIMITER = new Delimiter("\\.", true);
    private final String copyData;

    public PostgreSQLCopyParsedStatement(int pos, int line, int col, String sql, String copyData) {
        super(pos, line, col, sql, COPY_DELIMITER, true);
        this.copyData = copyData;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate) {
        Results results = new Results();
        try {
            CopyManager copyManager = new CopyManager(jdbcTemplate.getConnection().unwrap(BaseConnection.class));
            try {
                long updateCount = copyManager.copyIn(this.getSql(), (Reader)new StringReader(this.copyData));
                results.addResult(new Result(updateCount));
            }
            catch (IOException e) {
                throw new SQLException("Unable to execute COPY operation", e);
            }
        }
        catch (SQLException e) {
            jdbcTemplate.extractErrors(results, e);
        }
        return results;
    }
}

