/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.classpath;

import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.scanner.classpath.ClassPathLocationScanner;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OsgiClassPathLocationScanner
implements ClassPathLocationScanner {
    private static final Pattern EQUINOX_BUNDLE_ID_PATTERN = Pattern.compile("^\\d+");
    private static final Pattern FELIX_BUNDLE_ID_PATTERN = Pattern.compile("^[0-9a-f\\-]{36}_(\\d+)\\.\\d+");

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        TreeSet<String> resourceNames = new TreeSet<String>();
        Bundle bundle = this.getTargetBundleOrCurrent(FrameworkUtil.getBundle(this.getClass()), locationUrl);
        Enumeration entries = bundle.findEntries(locationUrl.getPath(), "*", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                String resourceName = this.getPathWithoutLeadingSlash(entry);
                resourceNames.add(resourceName);
            }
        }
        return resourceNames;
    }

    private Bundle getTargetBundleOrCurrent(Bundle currentBundle, URL locationUrl) {
        try {
            Bundle targetBundle = currentBundle.getBundleContext().getBundle(OsgiClassPathLocationScanner.getBundleId(locationUrl.getHost()));
            return targetBundle != null ? targetBundle : currentBundle;
        }
        catch (Exception e) {
            return currentBundle;
        }
    }

    static long getBundleId(String host) {
        Matcher matcher = FELIX_BUNDLE_ID_PATTERN.matcher(host);
        if (matcher.find()) {
            return Double.valueOf(matcher.group(1)).longValue();
        }
        matcher = EQUINOX_BUNDLE_ID_PATTERN.matcher(host);
        if (matcher.find()) {
            return Double.valueOf(matcher.group()).longValue();
        }
        throw new IllegalArgumentException("There's no bundleId in passed URL");
    }

    private String getPathWithoutLeadingSlash(URL entry) {
        String path = entry.getPath();
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

