/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.android;

import android.content.res.AssetManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.util.BomStrippingReader;

public class AndroidResource
extends LoadableResource {
    private final AssetManager assetManager;
    private final String fileName;
    private final String fileNameWithAbsolutePath;
    private final String fileNameWithRelativePath;
    private final Charset encoding;

    public AndroidResource(Location location, AssetManager assetManager, String path, String name, Charset encoding) {
        this.assetManager = assetManager;
        this.fileNameWithAbsolutePath = path + "/" + name;
        this.fileName = name;
        this.fileNameWithRelativePath = location.getPath().isEmpty() ? this.fileNameWithAbsolutePath : this.fileNameWithAbsolutePath.substring(location.getPath().length() + 1);
        this.encoding = encoding;
    }

    @Override
    public String getRelativePath() {
        return this.fileNameWithRelativePath;
    }

    @Override
    public String getAbsolutePath() {
        return this.fileNameWithAbsolutePath;
    }

    @Override
    public String getAbsolutePathOnDisk() {
        return null;
    }

    @Override
    public Reader read() {
        try {
            return new BufferedReader(new BomStrippingReader(new InputStreamReader(this.assetManager.open(this.fileNameWithAbsolutePath), this.encoding)));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to read asset: " + this.getAbsolutePath(), e);
        }
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }
}

