/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sybasease;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.sybasease.SybaseASEConnection;
import org.flywaydb.core.internal.database.sybasease.SybaseASEParser;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class SybaseASEDatabase
extends Database<SybaseASEConnection> {
    public SybaseASEDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected SybaseASEConnection getConnection(Connection connection) {
        return new SybaseASEConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("15.7");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("16.0", Edition.ENTERPRISE);
        this.recommendFlywayUpgradeIfNecessary("16.2");
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new SybaseASEParser(this.configuration), resource, mixed);
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        SybaseASEParser parser = new SybaseASEParser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    public LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE ${table} (\n    installed_rank INT NOT NULL,\n    version VARCHAR(50) NULL,\n    description VARCHAR(200) NOT NULL,\n    type VARCHAR(20) NOT NULL,\n    script VARCHAR(1000) NOT NULL,\n    checksum INT NULL,\n    installed_by VARCHAR(100) NOT NULL,\n    installed_on datetime DEFAULT getDate() NOT NULL,\n    execution_time INT NOT NULL,\n    success decimal NOT NULL,\n    PRIMARY KEY (installed_rank)\n)\nlock datarows on 'default'\ngo\n\nCREATE INDEX ${table}_s_idx ON ${table} (success)\ngo");
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((SybaseASEConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT user_name()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    protected String doQuote(String identifier) {
        return identifier;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

