/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.sqlserver.SQLServerDatabase;
import org.flywaydb.core.internal.database.sqlserver.SQLServerSchema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class SQLServerTable
extends Table<SQLServerDatabase, SQLServerSchema> {
    private final String databaseName;

    SQLServerTable(JdbcTemplate jdbcTemplate, SQLServerDatabase database, String databaseName, SQLServerSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
        this.databaseName = databaseName;
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + this, new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT CAST(CASE WHEN EXISTS(  SELECT 1 FROM [" + this.databaseName + "].INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?) THEN 1 ELSE 0 END AS BIT)", ((SQLServerSchema)this.schema).getName(), this.name);
    }

    @Override
    protected void doLock() throws SQLException {
        this.jdbcTemplate.execute("select * from " + this + " WITH (TABLOCKX)", new Object[0]);
    }

    @Override
    public String toString() {
        return ((SQLServerDatabase)this.database).quote(this.databaseName, ((SQLServerSchema)this.schema).getName(), this.name);
    }
}

