/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.sqlserver.SQLServerConnection;
import org.flywaydb.core.internal.database.sqlserver.SQLServerParser;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLServerDatabase
extends Database<SQLServerConnection> {
    private final boolean azure;

    public SQLServerDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
        try {
            this.azure = "SQL Azure".equals(((SQLServerConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT CAST(SERVERPROPERTY('edition') AS VARCHAR)", new String[0]));
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine database edition", e);
        }
    }

    @Override
    protected SQLServerConnection getConnection(Connection connection) {
        return new SQLServerConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("10.0");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("12.0", Edition.ENTERPRISE);
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("13.0", Edition.PRO);
        this.recommendFlywayUpgradeIfNecessary("15.0");
    }

    @Override
    protected String computeVersionDisplayName(MigrationVersion version) {
        if (this.getVersion().isAtLeast("8")) {
            if ("8".equals(this.getVersion().getMajorAsString())) {
                return "2000";
            }
            if ("9".equals(this.getVersion().getMajorAsString())) {
                return "2005";
            }
            if ("10".equals(this.getVersion().getMajorAsString())) {
                if ("0".equals(this.getVersion().getMinorAsString())) {
                    return "2008";
                }
                return "2008 R2";
            }
            if ("11".equals(this.getVersion().getMajorAsString())) {
                return "2012";
            }
            if ("12".equals(this.getVersion().getMajorAsString())) {
                return "2014";
            }
            if ("13".equals(this.getVersion().getMajorAsString())) {
                return "2016";
            }
            if ("14".equals(this.getVersion().getMajorAsString())) {
                return "2017";
            }
            if ("15".equals(this.getVersion().getMajorAsString())) {
                return "2019";
            }
        }
        return super.computeVersionDisplayName(version);
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new SQLServerParser(this.configuration), resource, mixed);
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        SQLServerParser parser = new SQLServerParser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((SQLServerConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUSER_SNAME()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll(identifier, "]", "]]");
    }

    @Override
    public String doQuote(String identifier) {
        return "[" + this.escapeIdentifier(identifier) + "]";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        String filegroup = this.azure || this.configuration.getTablespace() == null ? "" : " ON \"" + this.configuration.getTablespace() + "\"";
        return new StringResource("CREATE TABLE ${table_quoted} (\n    [installed_rank] INT NOT NULL,\n    [version] NVARCHAR(50),\n    [description] NVARCHAR(200),\n    [type] NVARCHAR(20) NOT NULL,\n    [script] NVARCHAR(1000) NOT NULL,\n    [checksum] INT,\n    [installed_by] NVARCHAR(100) NOT NULL,\n    [installed_on] DATETIME NOT NULL DEFAULT GETDATE(),\n    [execution_time] INT NOT NULL,\n    [success] BIT NOT NULL\n)" + filegroup + ";\nALTER TABLE ${table_quoted} ADD CONSTRAINT [${table}_pk] PRIMARY KEY ([installed_rank]);\n\nCREATE INDEX [${table}_s_idx] ON ${table_quoted} ([success]);\nGO\n");
    }

    boolean isAzure() {
        return this.azure;
    }
}

