/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import java.sql.Connection;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.saphana.SAPHANAConnection;
import org.flywaydb.core.internal.database.saphana.SAPHANAParser;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class SAPHANADatabase
extends Database<SAPHANAConnection> {
    public SAPHANADatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected SAPHANAConnection getConnection(Connection connection) {
        return new SAPHANAConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public void ensureSupported() {
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("2", Edition.ENTERPRISE);
        this.recommendFlywayUpgradeIfNecessaryForMajorVersion("2");
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new SAPHANAParser(this.configuration), resource, mixed);
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        SAPHANAParser parser = new SAPHANAParser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE \"${schema}\".\"${table}\" (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" TINYINT NOT NULL\n);\nALTER TABLE \"${schema}\".\"${table}\" ADD CONSTRAINT \"${table}_pk\" PRIMARY KEY (\"installed_rank\");\n\nCREATE INDEX \"${schema}\".\"${table}_s_idx\" ON \"${schema}\".\"${table}\" (\"success\");");
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

