/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.base.Type;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLDatabase;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLTable;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLType;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class PostgreSQLSchema
extends Schema<PostgreSQLDatabase> {
    PostgreSQLSchema(JdbcTemplate jdbcTemplate, PostgreSQLDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM pg_namespace WHERE nspname=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n    SELECT c.oid FROM pg_catalog.pg_class c\n    JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = c.oid AND d.deptype = 'e'\n    WHERE  n.nspname = ? AND d.objid IS NULL AND c.relkind IN ('r', 'v', 'S', 't')\n  UNION ALL\n    SELECT t.oid FROM pg_catalog.pg_type t\n    JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = t.oid AND d.deptype = 'e'\n    WHERE n.nspname = ? AND d.objid IS NULL AND t.typcategory NOT IN ('A', 'C')\n  UNION ALL\n    SELECT p.oid FROM pg_catalog.pg_proc p\n    JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = p.oid AND d.deptype = 'e'\n    WHERE n.nspname = ? AND d.objid IS NULL\n)", this.name, this.name, this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((PostgreSQLDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((PostgreSQLDatabase)this.database).quote(this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String statement : this.generateDropStatementsForMaterializedViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (Table table : this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForBaseTypes(true)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForRoutines()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForEnums()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForDomains()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForBaseTypes(false)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String sequenceName : sequenceNames) {
            statements.add("DROP SEQUENCE IF EXISTS " + ((PostgreSQLDatabase)this.database).quote(this.name, sequenceName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForBaseTypes(boolean recreate) throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("select typname, typcategory from pg_catalog.pg_type t left join pg_depend dep on dep.objid = t.oid and dep.deptype = 'e' where (t.typrelid = 0 OR (SELECT c.relkind = 'c' FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid)) and NOT EXISTS(SELECT 1 FROM pg_catalog.pg_type el WHERE el.oid = t.typelem AND el.typarray = t.oid) and t.typnamespace in (select oid from pg_catalog.pg_namespace where nspname = ?) and dep.objid is null and t.typtype != 'd'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP TYPE IF EXISTS " + ((PostgreSQLDatabase)this.database).quote(this.name, row.get("typname")) + " CASCADE");
        }
        if (recreate) {
            for (Map<String, String> row : rows) {
                if (!Arrays.asList("P", "U").contains(row.get("typcategory"))) continue;
                statements.add("CREATE TYPE " + ((PostgreSQLDatabase)this.database).quote(this.name, row.get("typname")));
            }
        }
        return statements;
    }

    private List<String> generateDropStatementsForRoutines() throws SQLException {
        String isAggregate = ((PostgreSQLDatabase)this.database).getVersion().isAtLeast("11") ? "pg_proc.prokind = 'a'" : "pg_proc.proisagg";
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("SELECT proname, oidvectortypes(proargtypes) AS args, " + isAggregate + " as agg FROM pg_proc INNER JOIN pg_namespace ns ON (pg_proc.pronamespace = ns.oid) LEFT JOIN pg_depend dep ON dep.objid = pg_proc.oid AND dep.deptype = 'e' WHERE ns.nspname = ? AND dep.objid IS NULL", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            String type = this.isTrue(row.get("agg")) ? "AGGREGATE" : "FUNCTION";
            statements.add("DROP " + type + " IF EXISTS " + ((PostgreSQLDatabase)this.database).quote(this.name, row.get("proname")) + "(" + row.get("args") + ") CASCADE");
        }
        return statements;
    }

    private boolean isTrue(String agg) {
        return agg != null && agg.toLowerCase(Locale.ENGLISH).startsWith("t");
    }

    private List<String> generateDropStatementsForEnums() throws SQLException {
        List<String> enumNames = this.jdbcTemplate.queryForStringList("SELECT t.typname FROM pg_catalog.pg_type t INNER JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace WHERE n.nspname = ? and t.typtype = 'e'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String enumName : enumNames) {
            statements.add("DROP TYPE " + ((PostgreSQLDatabase)this.database).quote(this.name, enumName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForDomains() throws SQLException {
        List<String> domainNames = this.jdbcTemplate.queryForStringList("SELECT t.typname as domain_name\nFROM pg_catalog.pg_type t\n       LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace\n       LEFT JOIN pg_depend dep ON dep.objid = t.oid AND dep.deptype = 'e'\nWHERE t.typtype = 'd'\n  AND n.nspname = ?\n  AND dep.objid IS NULL", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : domainNames) {
            statements.add("DROP DOMAIN " + ((PostgreSQLDatabase)this.database).quote(this.name, domainName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForMaterializedViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind = 'm' AND n.nspname = ?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP MATERIALIZED VIEW IF EXISTS " + ((PostgreSQLDatabase)this.database).quote(this.name, domainName) + " CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace LEFT JOIN pg_depend dep ON dep.objid = c.oid AND dep.deptype = 'e' WHERE c.relkind = 'v' AND  n.nspname = ? AND dep.objid IS NULL", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP VIEW IF EXISTS " + ((PostgreSQLDatabase)this.database).quote(this.name, domainName) + " CASCADE");
        }
        return statements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t LEFT JOIN pg_depend dep ON dep.objid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid AND dep.deptype = 'e' WHERE table_schema=? AND table_type='BASE TABLE' AND dep.objid IS NULL AND NOT (SELECT EXISTS (SELECT inhrelid FROM pg_catalog.pg_inherits WHERE inhrelid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid))", this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new PostgreSQLTable(this.jdbcTemplate, (PostgreSQLDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new PostgreSQLTable(this.jdbcTemplate, (PostgreSQLDatabase)this.database, this, tableName);
    }

    @Override
    protected Type getType(String typeName) {
        return new PostgreSQLType(this.jdbcTemplate, (PostgreSQLDatabase)this.database, this, typeName);
    }
}

