/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.h2.H2Connection;
import org.flywaydb.core.internal.database.h2.H2Parser;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class H2Database
extends Database<H2Connection> {
    boolean supportsDropSchemaCascade;

    public H2Database(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected H2Connection getConnection(Connection connection) {
        return new H2Connection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    protected MigrationVersion determineVersion() {
        try {
            int buildId = ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForInt("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'info.BUILD_ID'", new String[0]);
            return MigrationVersion.fromVersion(super.determineVersion().getVersion() + "." + buildId);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine H2 build ID", e);
        }
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("1.2.137");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("1.4", Edition.ENTERPRISE);
        this.recommendFlywayUpgradeIfNecessary("1.4.197");
        this.supportsDropSchemaCascade = this.getVersion().isAtLeast("1.4.197");
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        H2Parser parser = new H2Parser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE \"${schema}\".\"${table}\" (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\nALTER TABLE \"${schema}\".\"${table}\" ADD CONSTRAINT \"${table}_pk\" PRIMARY KEY (\"installed_rank\");\n\nCREATE INDEX \"${schema}\".\"${table}_s_idx\" ON \"${schema}\".\"${table}\" (\"success\");");
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new H2Parser(this.configuration), resource, mixed);
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT USER()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

