/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.db2;

import java.io.IOException;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class DB2Parser
extends Parser {
    private static final String COMMENT_DIRECTIVE = "--#";
    private static final String SET_TERMINATOR_DIRECTIVE = "--#SET TERMINATOR ";

    public DB2Parser(Configuration configuration) {
        super(configuration, COMMENT_DIRECTIVE.length());
    }

    @Override
    protected void adjustBlockDepth(ParserContext context, List<Token> keywords) {
        Token previousPreviousToken;
        if (keywords.size() < 2) {
            return;
        }
        Token token = keywords.get(keywords.size() - 1);
        Token previousToken = keywords.get(keywords.size() - 2);
        Token token2 = previousPreviousToken = keywords.size() > 2 ? keywords.get(keywords.size() - 3) : null;
        if ("BEGIN".equals(token.getText()) && (!"ROW".equals(previousToken.getText()) || previousPreviousToken == null || "EACH".equals(previousPreviousToken.getText())) || ("CASE".equals(token.getText()) || "DO".equals(token.getText()) || "IF".equals(token.getText()) || "REPEAT".equals(token.getText())) && !"END".equals(previousToken.getText())) {
            context.increaseBlockDepth();
        } else if ("END".equals(token.getText()) && !"ROW".equals(previousToken.getText())) {
            context.decreaseBlockDepth();
        }
    }

    @Override
    protected void resetDelimiter(ParserContext context) {
    }

    @Override
    protected boolean isCommentDirective(String peek) {
        return peek.startsWith(COMMENT_DIRECTIVE);
    }

    @Override
    protected Token handleCommentDirective(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        if (SET_TERMINATOR_DIRECTIVE.equals(reader.peek(SET_TERMINATOR_DIRECTIVE.length()))) {
            reader.swallow(SET_TERMINATOR_DIRECTIVE.length());
            String delimiter = reader.readUntilExcluding('\n', '\r');
            return new Token(TokenType.NEW_DELIMITER, pos, line, col, delimiter.trim(), delimiter, context.getParensDepth());
        }
        reader.swallowUntilExcluding('\n', '\r');
        return new Token(TokenType.COMMENT, pos, line, col, null, null, context.getParensDepth());
    }
}

