/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.db2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.db2.DB2Connection;
import org.flywaydb.core.internal.database.db2.DB2Parser;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class DB2Database
extends Database<DB2Connection> {
    public DB2Database(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected DB2Connection getConnection(Connection connection) {
        return new DB2Connection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("9.7");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("11.1", Edition.ENTERPRISE);
        this.recommendFlywayUpgradeIfNecessary("11.1");
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        DB2Parser parser = new DB2Parser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new DB2Parser(this.configuration), resource, mixed);
    }

    @Override
    public LoadableResource getRawCreateScript() {
        String tablespace = this.configuration.getTablespace() == null ? "" : " IN \"" + this.configuration.getTablespace() + "\"";
        return new StringResource("CREATE TABLE \"${schema}\".\"${table}\" (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" SMALLINT NOT NULL,\n    CONSTRAINT \"${table}_s\" CHECK (\"success\" in(0,1))\n) ORGANIZE BY ROW" + tablespace + ";\nALTER TABLE \"${schema}\".\"${table}\" ADD CONSTRAINT \"${table}_pk\" PRIMARY KEY (\"installed_rank\");\n\nCREATE INDEX \"${schema}\".\"${table}_s_idx\" ON \"${schema}\".\"${table}\" (\"success\");");
    }

    @Override
    public String getSelectStatement(Table table, int maxCachedInstalledRank) {
        return super.getSelectStatement(table, maxCachedInstalledRank) + " WITH UR";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((DB2Connection)this.getMainConnection()).getJdbcTemplate().queryForString("select CURRENT_USER from sysibm.sysdummy1", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

