/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBConnection;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBParser;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.util.StringUtils;

public class CockroachDBDatabase
extends Database<CockroachDBConnection> {
    public CockroachDBDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected CockroachDBConnection getConnection(Connection connection) {
        return new CockroachDBConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("1.1");
        this.recommendFlywayUpgradeIfNecessary("2.1");
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        CockroachDBParser parser = new CockroachDBParser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new CockroachDBParser(this.configuration), resource, mixed);
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE \"${schema}\".\"${table}\" (\n    \"installed_rank\" INT NOT NULL PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INTEGER,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT now(),\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n\nCREATE INDEX \"${table}_s_idx\" ON \"${schema}\".\"${table}\" (\"success\");");
    }

    @Override
    protected MigrationVersion determineVersion() {
        String version;
        try {
            version = ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT value FROM crdb_internal.node_build_info where field='Version'", new String[0]);
            if (version == null) {
                version = ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT value FROM crdb_internal.node_build_info where field='Tag'", new String[0]);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine CockroachDB version", e);
        }
        int firstDot = version.indexOf(".");
        int majorVersion = Integer.parseInt(version.substring(1, firstDot));
        String minorPatch = version.substring(firstDot + 1);
        int minorVersion = Integer.parseInt(minorPatch.substring(0, minorPatch.indexOf(".")));
        return MigrationVersion.fromVersion(majorVersion + "." + minorVersion);
    }

    public String getDbName() {
        return "cockroachdb";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("(SELECT * FROM [SHOW SESSION_USER])", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

